/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Placeholders;
import adams.core.management.OS;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class PlaceholderFile
extends File {
    private static final long serialVersionUID = 4767449993057576987L;

    public PlaceholderFile() {
        this("${CWD}");
    }

    public PlaceholderFile(File file) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(file.getAbsolutePath())));
    }

    public PlaceholderFile(String pathname) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(pathname)));
    }

    public PlaceholderFile(String parent, String child) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(parent)), child);
    }

    public PlaceholderFile(File parent, String child) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(parent.getPath())), child);
    }

    public PlaceholderFile(URI uri) {
        super(uri);
    }

    @Override
    public boolean canExecute() {
        return new File(this.expand(this.getPath())).canExecute();
    }

    @Override
    public boolean canRead() {
        return new File(this.expand(this.getPath())).canRead();
    }

    @Override
    public boolean canWrite() {
        return new File(this.expand(this.getPath())).canWrite();
    }

    @Override
    public int compareTo(File pathname) {
        return this.getAbsoluteFile().compareTo(pathname.getAbsoluteFile());
    }

    @Override
    public boolean createNewFile() throws IOException {
        return new File(this.expand(this.getPath())).createNewFile();
    }

    @Override
    public boolean delete() {
        return new File(this.expand(this.getPath())).delete();
    }

    @Override
    public void deleteOnExit() {
        new File(this.expand(this.getPath())).deleteOnExit();
    }

    @Override
    public boolean exists() {
        return new File(this.expand(this.getPath())).exists();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return new File(this.expand(this.getPath())).getCanonicalPath();
    }

    @Override
    public long getFreeSpace() {
        return new File(this.expand(this.getPath())).getFreeSpace();
    }

    @Override
    public long getTotalSpace() {
        return new File(this.expand(this.getPath())).getTotalSpace();
    }

    @Override
    public long getUsableSpace() {
        return new File(this.expand(this.getPath())).getUsableSpace();
    }

    @Override
    public boolean isAbsolute() {
        return new File(this.expand(this.getPath())).isAbsolute();
    }

    @Override
    public boolean isDirectory() {
        return new File(this.expand(this.getPath())).isDirectory();
    }

    @Override
    public boolean isFile() {
        return new File(this.expand(this.getPath())).isFile();
    }

    @Override
    public boolean isHidden() {
        return new File(this.expand(this.getPath())).isHidden();
    }

    @Override
    public long lastModified() {
        return new File(this.expand(this.getPath())).lastModified();
    }

    @Override
    public long length() {
        return new File(this.expand(this.getPath())).length();
    }

    @Override
    public String[] list() {
        return new File(this.expand(this.getPath())).list();
    }

    public String[] list(String regExp) {
        ArrayList<String> result = new ArrayList<String>();
        String[] list = new File(this.expand(this.getPath())).list();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].matches(regExp)) continue;
            result.add(list[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    protected PlaceholderFile[] toPlaceholderFiles(File[] files) {
        if (files == null) {
            return null;
        }
        PlaceholderFile[] result = new PlaceholderFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new PlaceholderFile(files[i]);
        }
        return result;
    }

    public PlaceholderFile[] listFiles() {
        return this.toPlaceholderFiles(new File(this.expand(this.getPath())).listFiles());
    }

    public PlaceholderFile[] listFiles(FilenameFilter filter) {
        return this.toPlaceholderFiles(new File(this.expand(this.getPath())).listFiles(filter));
    }

    public PlaceholderFile[] listFiles(FileFilter filter) {
        return this.toPlaceholderFiles(new File(this.expand(this.getPath())).listFiles(filter));
    }

    @Override
    public boolean mkdir() {
        return new File(this.expand(this.getPath())).mkdir();
    }

    @Override
    public boolean renameTo(File dest) {
        File from = new File(this.expand(this.getPath()));
        File to = new File(this.expand(dest.getPath()));
        return from.renameTo(to);
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return new File(this.expand(this.getPath())).setExecutable(executable, ownerOnly);
    }

    @Override
    public boolean setLastModified(long time) {
        return new File(this.expand(this.getPath())).setLastModified(time);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return new File(this.expand(this.getPath())).setReadable(readable, ownerOnly);
    }

    @Override
    public boolean setReadOnly() {
        return new File(this.expand(this.getPath())).setReadOnly();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return new File(this.expand(this.getPath())).setWritable(writable, ownerOnly);
    }

    @Override
    public String getParent() {
        return new File(this.expand(this.getPath())).getParent();
    }

    @Override
    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new PlaceholderFile(p);
    }

    protected String expand(String path) {
        String result = path;
        if (result.indexOf("${") > -1) {
            result = Placeholders.getSingleton().expand(this.getPath());
        }
        return result;
    }

    @Override
    public String getAbsolutePath() {
        File file = new File(this.expand(this.getPath()));
        String result = file.getAbsolutePath();
        return result;
    }

    protected static String fixSeparator(String path) {
        if (path == null) {
            return path;
        }
        String prefix = "";
        if (path.startsWith("\\\\")) {
            prefix = "\\\\";
            path = path.substring(2);
        } else if (path.startsWith("//")) {
            prefix = "\\\\";
            path = path.substring(2);
        }
        path = OS.isWindows() ? path.replace('/', '\\') : path.replace('\\', '/');
        return prefix + path;
    }

    public static boolean isValid(String file) {
        return PlaceholderFile.isValid(new PlaceholderFile(file));
    }

    public static boolean isValid(PlaceholderFile file) {
        try {
            file.getAbsolutePath();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getExtension() {
        return this.getExtension("");
    }

    public String getExtension(String suffix) {
        if (suffix.length() > 0 && !suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        int start = this.getName().length() - suffix.length() - 1;
        int pos = this.getName().lastIndexOf(46, start);
        if (pos > -1) {
            return this.getName().substring(pos + 1);
        }
        return "";
    }

    public PlaceholderFile changeExtension(String newExt) {
        return this.changeExtension(this.getExtension(), newExt);
    }

    public PlaceholderFile changeExtension(String oldExt, String newExt) {
        return new PlaceholderFile(this.getPath() + separator + this.getName().replaceAll(oldExt + "$", newExt));
    }

    @Override
    public Path toPath() {
        return Paths.get(this.toURI());
    }
}

