/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public abstract class AbstractOutputPrinter {
    protected boolean m_StdOut;
    protected String m_ID;
    protected BufferedReader m_Reader;

    public AbstractOutputPrinter(boolean stdout, Process process) {
        this.initialize(stdout, process);
    }

    protected void initialize(boolean stdout, Process process) {
        this.m_StdOut = stdout;
        this.m_ID = "" + process.hashCode();
        this.m_Reader = this.m_StdOut ? new BufferedReader(new InputStreamReader(process.getInputStream())) : new BufferedReader(new InputStreamReader(process.getErrorStream()));
    }

    public String getID() {
        return this.m_ID;
    }

    public boolean isStdOut() {
        return this.m_StdOut;
    }

    protected String read() {
        try {
            return this.m_Reader.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract void output(String var1);

    public boolean process() {
        String line = this.read();
        if (line != null) {
            this.output(line);
            return true;
        }
        return false;
    }

    public String toString() {
        return "id=" + this.m_ID + ", stdout=" + this.m_StdOut;
    }
}

