/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.Properties;
import adams.env.Environment;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class LocaleHelper {
    public static final String FILENAME = "Locale.props";
    public static final String LOCALE = "Locale";
    public static final String LOCALE_DEFAULT = "Default";
    public static final String LOCALE_EN_US = "en_US";
    protected static LocaleHelper m_Singleton;
    protected Properties m_Properties;
    protected boolean m_Modified;
    protected char m_DecimalSeparator;
    protected char m_GroupingSeparator;
    protected Locale m_LocaleEnUS;

    private LocaleHelper() {
        this.initialize();
        this.reload();
    }

    protected void initialize() {
        this.m_LocaleEnUS = new Locale(LOCALE_EN_US);
    }

    public void initializeLocale() {
        Locale locale = LocaleHelper.valueOf(this.getLocale());
        Locale.setDefault(locale);
        this.m_DecimalSeparator = DecimalFormatSymbols.getInstance(locale).getDecimalSeparator();
        this.m_GroupingSeparator = DecimalFormatSymbols.getInstance(locale).getGroupingSeparator();
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public String getLocale() {
        return this.m_Properties.getProperty(LOCALE, Locale.getDefault().toString());
    }

    public void setLocale(String value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(LOCALE, value);
    }

    public Locale getDefault() {
        return Locale.getDefault();
    }

    public void setDefault(String value) {
        Locale.setDefault(LocaleHelper.valueOf(value));
    }

    public void setDefault(Locale value) {
        Locale.setDefault(value);
    }

    public Locale getEnUS() {
        return this.m_LocaleEnUS;
    }

    public char getDecimalSeparator() {
        return this.m_DecimalSeparator;
    }

    public char getDecimalSeparator(Locale locale) {
        return DecimalFormatSymbols.getInstance(locale).getDecimalSeparator();
    }

    public char getGroupingSeparator() {
        return this.m_GroupingSeparator;
    }

    public char getGroupingSeparator(Locale locale) {
        return DecimalFormatSymbols.getInstance(locale).getGroupingSeparator();
    }

    public NumberFormat getNumberFormat() {
        return this.getNumberFormat(Locale.getDefault());
    }

    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat result = NumberFormat.getNumberInstance(locale);
        result.setGroupingUsed(false);
        result.setMaximumFractionDigits(14);
        result.setMinimumFractionDigits(1);
        return result;
    }

    public NumberFormat getNumberFormatEnUS() {
        return this.getNumberFormat(this.m_LocaleEnUS);
    }

    public synchronized void reload() {
        this.m_Modified = false;
        try {
            this.m_Properties = Environment.getInstance().read("locale");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public synchronized boolean save() {
        boolean result = Environment.getInstance().write("locale", this.m_Properties);
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public static synchronized LocaleHelper getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new LocaleHelper();
        }
        return m_Singleton;
    }

    public static String toString(Locale l) {
        String result = l.toString();
        if (result.equals(Locale.getDefault().toString())) {
            result = LOCALE_DEFAULT;
        }
        return result;
    }

    public static Locale valueOf(String str) {
        if (str.equals(LOCALE_DEFAULT)) {
            return Locale.getDefault();
        }
        if (str.indexOf(95) == -1) {
            return new Locale(str);
        }
        String[] parts = str.split("_");
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        System.err.println("Failed to parse locale '" + str + "', using default!");
        return Locale.getDefault();
    }

    public static String[] getIDs() {
        Locale[] locales;
        ArrayList<String> result = new ArrayList<String>();
        for (Locale l : locales = Locale.getAvailableLocales()) {
            result.add(l.toString());
        }
        Collections.sort(result);
        result.add(0, LOCALE_DEFAULT);
        return result.toArray(new String[result.size()]);
    }
}

