/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.Properties;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TimeZone;

public class TimeZoneHelper {
    public static final String FILENAME = "TimeZone.props";
    public static final String TIMEZONE = "TimeZone";
    public static final String DEFAULT_TIMEZONE = "Default";
    protected static TimeZoneHelper m_Singleton;
    protected Properties m_Properties;
    protected boolean m_Modified;

    private TimeZoneHelper() {
        this.reload();
    }

    public void initializeTimezone() {
        TimeZone.setDefault(TimeZone.getTimeZone(this.getTimezone()));
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public String getTimezone() {
        return this.m_Properties.getProperty(TIMEZONE, TimeZone.getDefault().getID());
    }

    public void setTimezone(String value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(TIMEZONE, value);
    }

    public synchronized void reload() {
        this.m_Modified = false;
        try {
            this.m_Properties = Environment.getInstance().read("timezone");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public synchronized boolean save() {
        boolean result = Environment.getInstance().write("timezone", this.m_Properties);
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public static synchronized TimeZoneHelper getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new TimeZoneHelper();
        }
        return m_Singleton;
    }

    public static String toString(TimeZone tz) {
        String result = tz.getID();
        if (result.equals(TimeZone.getDefault().getID())) {
            result = DEFAULT_TIMEZONE;
        }
        return result;
    }

    public static TimeZone valueOf(String str) {
        if (str.equals(DEFAULT_TIMEZONE)) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(str);
    }

    public static String[] getIDs() {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList((Object[])TimeZone.getAvailableIDs().clone()));
        Collections.sort(result);
        result.add(0, DEFAULT_TIMEZONE);
        return result.toArray(new String[result.size()]);
    }
}

