/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;

public class InternetHelper {
    protected static String m_IPNetworkInterface;
    protected static String m_HostnameNetworkInterface;
    protected static String m_IP;
    protected static String m_Hostname;

    public static synchronized String getIPFromNetworkInterface() {
        String result = null;
        if (m_IPNetworkInterface == null) {
            ArrayList<String> list = new ArrayList<String>();
            boolean found = false;
            try {
                Enumeration<NetworkInterface> enmI = NetworkInterface.getNetworkInterfaces();
                while (enmI.hasMoreElements()) {
                    NetworkInterface intf = enmI.nextElement();
                    Enumeration<InetAddress> enmA = intf.getInetAddresses();
                    while (enmA.hasMoreElements()) {
                        InetAddress addr = enmA.nextElement();
                        list.add(addr.getHostAddress());
                        if (addr.getHostName().indexOf(58) != -1) continue;
                        result = addr.getHostAddress();
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = list.size() > 0 ? (String)list.get(0) : "<unknown>";
            }
            m_IPNetworkInterface = result;
        } else {
            result = m_IPNetworkInterface;
        }
        return result;
    }

    public static synchronized String getHostnameFromNetworkInterface() {
        String result = null;
        if (m_HostnameNetworkInterface == null) {
            ArrayList<String> list = new ArrayList<String>();
            boolean found = false;
            try {
                Enumeration<NetworkInterface> enmI = NetworkInterface.getNetworkInterfaces();
                while (enmI.hasMoreElements()) {
                    NetworkInterface intf = enmI.nextElement();
                    Enumeration<InetAddress> enmA = intf.getInetAddresses();
                    while (enmA.hasMoreElements()) {
                        InetAddress addr = enmA.nextElement();
                        list.add(addr.getHostName());
                        if (addr.getHostName().indexOf(58) != -1) continue;
                        result = addr.getHostName();
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = list.size() > 0 ? (String)list.get(0) : "<unknown>";
            }
            m_HostnameNetworkInterface = result;
        } else {
            result = m_HostnameNetworkInterface;
        }
        return result;
    }

    public static synchronized String getLocalHostIP() {
        String result;
        if (m_IP == null) {
            try {
                result = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                result = InternetHelper.getIPFromNetworkInterface();
            }
            m_IP = result;
        } else {
            result = m_IP;
        }
        return result;
    }

    public static synchronized String getLocalHostName() {
        String result;
        if (m_Hostname == null) {
            try {
                result = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                result = InternetHelper.getHostnameFromNetworkInterface();
            }
            m_Hostname = result;
        } else {
            result = m_Hostname;
        }
        return result;
    }

    public static String decodeBase64(String base64) {
        String result;
        try {
            result = new String(Base64.decodeBase64((byte[])base64.getBytes()));
        }
        catch (Exception e) {
            System.err.println("Failed to decode base64 string: " + base64);
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String encodeBase64(String raw) {
        return Base64.encodeBase64String((byte[])raw.getBytes());
    }

    public static String encodeBase64(byte[] raw) {
        return Base64.encodeBase64String((byte[])raw);
    }

    public static String encodeUrlAsFilename(String url) {
        String result = url;
        result = result.replace(":", "(c)");
        result = result.replace("/", "(s)");
        result = result.replace("&", "(a)");
        result = result.replace("?", "(q)");
        return result;
    }

    public static String decodeUrlFromFilename(String filename) {
        String result = filename;
        result = result.replace("(c)", ":");
        result = result.replace("(s)", "/");
        result = result.replace("(a)", "&");
        result = result.replace("(q)", "?");
        return result;
    }

    public static String extractUrlFromFilename(String filename) {
        int start = filename.indexOf("((");
        int end = filename.lastIndexOf("))");
        String result = start > -1 && end > start ? InternetHelper.decodeUrlFromFilename(filename.substring(start + 2, end)) : InternetHelper.decodeUrlFromFilename(filename);
        return result;
    }

    public static String createUrlFilename(String path, String prefix, String url, String suffix, String ext) {
        StringBuilder result = new StringBuilder();
        if (path != null) {
            result.append(path);
            if (!path.endsWith(File.separator)) {
                result.append(File.separator);
            }
        }
        if (prefix != null) {
            result.append(prefix);
        }
        result.append("((" + InternetHelper.encodeUrlAsFilename(url) + "))");
        if (suffix != null) {
            result.append(suffix);
        }
        if (ext != null) {
            if (!ext.startsWith(".")) {
                result.append(".");
            }
            result.append(ext);
        }
        return result.toString();
    }
}

