/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLister;
import adams.core.StaticClassLister;
import adams.core.option.DefaultCommandLineHandler;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class AbstractCommandLineHandler
implements Serializable {
    private static final long serialVersionUID = -200830732847780663L;
    public static final String FILENAME = "CommandLineHandlers.props";
    public static final String KEY_HANDLERS = "Handlers";
    protected static Hashtable<Class, Class> m_Cache = new Hashtable();
    protected static String[] m_Handlers = null;
    protected static Class[] m_HandlerClasses = null;

    public abstract Object fromCommandLine(String var1);

    public abstract Object fromArray(String[] var1);

    public abstract String toCommandLine(Object var1);

    public abstract String toShortCommandLine(Object var1);

    public abstract String[] toArray(Object var1);

    public abstract String[] getOptions(Object var1);

    public abstract boolean setOptions(Object var1, String[] var2);

    public abstract String[] splitOptions(String var1);

    public abstract String joinOptions(String[] var1);

    public boolean handles(Object obj) {
        return this.handles(obj.getClass());
    }

    public abstract boolean handles(Class var1);

    protected static synchronized void initHandlers() {
        if (m_Handlers != null) {
            return;
        }
        m_Handlers = ClassLister.getSingleton().getClassnames(AbstractCommandLineHandler.class);
        if (m_Handlers.length == 0) {
            String propsfile = "adams/core/option/CommandLineHandlers.props";
            m_Handlers = StaticClassLister.getSingleton().getClasses(propsfile, KEY_HANDLERS);
            System.err.println("WARNING: no commandline handlers determined using dynamic class discovery, falling back to using class names stored in '" + propsfile + "' files.");
        }
        m_HandlerClasses = new Class[m_Handlers.length];
        for (int i = 0; i < m_Handlers.length; ++i) {
            try {
                AbstractCommandLineHandler.m_HandlerClasses[i] = Class.forName(m_Handlers[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate commandline handler '" + m_Handlers[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized AbstractCommandLineHandler getHandler(Object obj) {
        return AbstractCommandLineHandler.getHandler(obj.getClass());
    }

    public static synchronized AbstractCommandLineHandler getHandler(Class cls) {
        AbstractCommandLineHandler result = null;
        AbstractCommandLineHandler.initHandlers();
        if (m_Cache.containsKey(cls)) {
            try {
                result = (AbstractCommandLineHandler)m_Cache.get(cls).newInstance();
                return result;
            }
            catch (Exception e) {
                result = null;
            }
        }
        for (int i = 0; i < m_HandlerClasses.length; ++i) {
            if (m_HandlerClasses[i] == DefaultCommandLineHandler.class) continue;
            try {
                AbstractCommandLineHandler handler = (AbstractCommandLineHandler)m_HandlerClasses[i].newInstance();
                if (!handler.handles(cls)) continue;
                result = handler;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new DefaultCommandLineHandler();
        }
        m_Cache.put(cls, result.getClass());
        return result;
    }

    public static synchronized String[] getHandlers() {
        AbstractCommandLineHandler.initHandlers();
        return m_Handlers;
    }
}

