/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionTraverserWithResult;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionManager;
import adams.core.option.OptionTraversalPath;
import adams.flow.core.AbstractActor;

public class VariablesInstanceLister
extends AbstractOptionTraverserWithResult<String> {
    private static final long serialVersionUID = -6561961647781822476L;
    protected StringBuilder m_Result;

    @Override
    public String globalInfo() {
        return "Lists the hashcodes of the " + Variables.class.getName() + " objects " + "in use by the " + OptionManager.class.getName() + " objects.";
    }

    @Override
    public void resetResult() {
        this.m_Result = new StringBuilder();
        this.m_Result.append("Path");
        this.m_Result.append("\t");
        this.m_Result.append("Class");
        this.m_Result.append("\t");
        this.m_Result.append("Property");
        this.m_Result.append("\t");
        this.m_Result.append("Variables (OptionManager/Actor)");
        this.m_Result.append("\n");
    }

    @Override
    public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
        this.m_Result.append(path.getPath());
        this.m_Result.append("\t");
        this.m_Result.append(option.getOptionHandler().getClass().getName());
        this.m_Result.append("\t");
        this.m_Result.append(option.getProperty());
        this.m_Result.append("\t");
        this.m_Result.append("-/-");
        this.m_Result.append("\n");
    }

    @Override
    public void handleClassOption(ClassOption option, OptionTraversalPath path) {
        this.handleArgumentOption(option, path);
    }

    @Override
    public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
        this.m_Result.append(path.getPath());
        this.m_Result.append("\t");
        this.m_Result.append(option.getOptionHandler().getClass().getName());
        this.m_Result.append("\t");
        this.m_Result.append(option.getProperty());
        this.m_Result.append("\t");
        this.m_Result.append(option.getOwner().getVariables().hashCode());
        if (option.getOptionHandler() instanceof AbstractActor) {
            Variables vars = ((AbstractActor)option.getOptionHandler()).getVariables();
            if (vars != null) {
                this.m_Result.append("/" + vars.hashCode());
            } else {
                this.m_Result.append("/-");
            }
        } else {
            this.m_Result.append("/-");
        }
        this.m_Result.append("\n");
    }

    @Override
    public boolean canHandle(AbstractOption option) {
        return true;
    }

    @Override
    public boolean canRecurse(Class cls) {
        return true;
    }

    @Override
    public boolean canRecurse(Object obj) {
        return this.canRecurse(obj.getClass());
    }

    @Override
    public String getResult() {
        return this.m_Result.toString();
    }
}

