/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.InformativeStatisticSupporter;
import java.util.Iterator;

public class InformativeStatistic
extends AbstractConversion {
    private static final long serialVersionUID = 1016763925162792131L;

    @Override
    public String globalInfo() {
        return "Turns the statistics obtained from a " + InformativeStatisticSupporter.class.getName() + " into a spreadsheet.";
    }

    @Override
    public Class accepts() {
        return InformativeStatisticSupporter.class;
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        Object stats = ((InformativeStatisticSupporter)this.m_Input).toStatistic();
        SpreadSheet result = new SpreadSheet();
        result.setName(stats.getStatisticDescription());
        Row row = result.getHeaderRow();
        row.addCell("S").setContent("Statistic");
        row.addCell("V").setContent("Value");
        Iterator<String> iter = stats.statisticNames();
        while (iter.hasNext()) {
            String name = iter.next();
            row = result.addRow();
            row.addCell("S").setContent(name);
            row.addCell("V").setContent(stats.getStatistic(name));
        }
        return result;
    }
}

