/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.ClassCrossReference;
import adams.core.Constants;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractStringConversion;
import adams.data.conversion.BackQuote;
import adams.data.conversion.UnBackQuote;
import adams.data.conversion.UnQuote;
import java.util.ArrayList;

public class Quote
extends AbstractStringConversion
implements ClassCrossReference {
    private static final long serialVersionUID = 8391531953153963013L;
    protected QuoteType m_QuoteType;
    protected boolean m_DoubleUp;
    protected boolean m_Force;

    @Override
    public String globalInfo() {
        return "Surrounds a string with quotes (single or double), if necessary due to blanks or other characters (new line, tab) in the string.\nHowever, you can also 'force' the quoting.";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{UnQuote.class, BackQuote.class, UnBackQuote.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("quote-type", "quoteType", (Object)QuoteType.DOUBLE);
        this.m_OptionManager.add("double-up", "doubleUp", false);
        this.m_OptionManager.add("force", "force", false);
    }

    public void setQuoteType(QuoteType value) {
        this.m_QuoteType = value;
        this.reset();
    }

    public QuoteType getQuoteType() {
        return this.m_QuoteType;
    }

    public String quoteTypeTipText() {
        return "The type of quote to use.";
    }

    public void setDoubleUp(boolean value) {
        this.m_DoubleUp = value;
        this.reset();
    }

    public boolean getDoubleUp() {
        return this.m_DoubleUp;
    }

    public String doubleUpTipText() {
        return "If enabled, internal quotes get doubled up rather than escaped with backslashes.";
    }

    public void setForce(boolean value) {
        this.m_Force = value;
        this.reset();
    }

    public boolean getForce() {
        return this.m_Force;
    }

    public String forceTipText() {
        return "If enabled, forces the quoting of the string.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "quoteType", (Object)this.m_QuoteType, "type: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "force", this.m_Force, "force"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "doubleUp", this.m_DoubleUp, "double-up"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    protected Object doConvert() throws Exception {
        String result;
        String input = (String)this.m_Input;
        switch (this.m_QuoteType) {
            case DOUBLE: {
                result = this.m_DoubleUp ? Utils.doubleUpQuotes(input, '\"', Constants.BACKQUOTE_CHARS, Constants.BACKQUOTED_STRINGS) : Utils.doubleQuote(input);
                if (!this.m_Force || result.startsWith("\"")) break;
                result = "\"" + result + "\"";
                break;
            }
            case SINGLE: {
                result = this.m_DoubleUp ? Utils.doubleUpQuotes(input, '\'', Constants.BACKQUOTE_CHARS, Constants.BACKQUOTED_STRINGS) : Utils.quote(input);
                if (!this.m_Force || result.startsWith("'")) break;
                result = "'" + result + "'";
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled quote type: " + (Object)((Object)this.m_QuoteType));
            }
        }
        return result;
    }

    public static enum QuoteType {
        SINGLE,
        DOUBLE,
        DOUBLE_UP;

    }
}

