/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractValidateString;

public class StringToValidVariableName
extends AbstractValidateString {
    private static final long serialVersionUID = 5528425779551772381L;
    protected boolean m_Pad;

    @Override
    public String globalInfo() {
        return "Turns any string into a valid variable name.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pad", "pad", false);
    }

    public void setPad(boolean value) {
        this.m_Pad = value;
        this.reset();
    }

    public boolean getPad() {
        return this.m_Pad;
    }

    public String padTipText() {
        return "If enabled, the variable gets padded with @{ and }.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        String value = QuickInfoHelper.toString((OptionHandler)this, "pad", this.m_Pad, "pad", ", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected String process(String input, String replace) throws Exception {
        String result = Variables.toValidName(input, replace);
        if (this.m_Pad) {
            result = Variables.padName(result);
        }
        return result;
    }
}

