/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import java.util.List;

public class FixedColumnText
extends AbstractFeatureConverter<String, String> {
    private static final long serialVersionUID = 2245576408802564218L;
    protected int m_ColumnWidth;
    protected String m_SeparatorCells;
    protected String m_SeparatorHeader;
    protected String m_MissingValue;

    @Override
    public String globalInfo() {
        return "Simple feature converter that generates textual output with fixed column width.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-width", "columnWidth", 10, 1, null);
        this.m_OptionManager.add("separator-cells", "separatorCells", " | ");
        this.m_OptionManager.add("separator-header", "separatorHeader", "-");
        this.m_OptionManager.add("missing-value", "missingValue", "");
    }

    public void setColumnWidth(int value) {
        this.m_ColumnWidth = value;
        this.reset();
    }

    public int getColumnWidth() {
        return this.m_ColumnWidth;
    }

    public String columnWidthTipText() {
        return "The width of a column in characters.";
    }

    public void setSeparatorCells(String value) {
        this.m_SeparatorCells = value;
        this.reset();
    }

    public String getSeparatorCells() {
        return this.m_SeparatorCells;
    }

    public String separatorCellsTipText() {
        return "The separator to use between cells.";
    }

    public void setSeparatorHeader(String value) {
        this.m_SeparatorHeader = value;
        this.reset();
    }

    public String getSeparatorHeader() {
        return this.m_SeparatorHeader;
    }

    public String separatorHeaderTipText() {
        return "The separator to use between header and data.";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to use for missing values.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "columnWidth", this.m_ColumnWidth, "width: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "separatorCells", this.m_SeparatorCells, ", cells: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "separatorHeader", this.m_SeparatorHeader, ", header: ");
        return result;
    }

    @Override
    public Class getDatasetFormat() {
        return String.class;
    }

    @Override
    public Class getRowFormat() {
        return String.class;
    }

    protected String fixLength(String s, int max, boolean rightFill) {
        if (s.length() > max) {
            return s.substring(0, max);
        }
        StringBuilder result = new StringBuilder(s);
        while (result.length() < max) {
            if (rightFill) {
                result.append(" ");
                continue;
            }
            result.insert(0, " ");
        }
        return result.toString();
    }

    @Override
    protected String doGenerateHeader(HeaderDefinition header) {
        StringBuilder result = new StringBuilder();
        for (String name : header.getNames()) {
            if (result.length() > 0) {
                result.append(this.m_SeparatorCells);
            }
            result.append(this.fixLength(name, this.m_ColumnWidth, true));
        }
        result.append("\n");
        int max = header.size() * this.m_ColumnWidth + this.m_SeparatorCells.length() * (this.m_ColumnWidth - 1);
        StringBuilder sep = new StringBuilder();
        while (sep.length() < max) {
            sep.append(this.m_SeparatorHeader);
        }
        if (sep.length() > max) {
            sep.delete(max, sep.length());
        }
        result.append(sep.toString());
        return result.toString();
    }

    @Override
    protected String doGenerateRow(List data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            Object value = data.get(i);
            if (result.length() > 0) {
                result.append(this.m_SeparatorCells);
            }
            if (value == null) {
                result.append(this.fixLength(this.m_MissingValue, this.m_ColumnWidth, this.m_HeaderDefinition.getType(i) != DataType.NUMERIC));
                continue;
            }
            result.append(this.fixLength(value.toString(), this.m_ColumnWidth, this.m_HeaderDefinition.getType(i) != DataType.NUMERIC));
        }
        return result.toString();
    }
}

