/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractTextReaderWithEncoding;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;

public class SingleStringTextReader
extends AbstractTextReaderWithEncoding<String> {
    private static final long serialVersionUID = -6754529362096587742L;
    protected transient Scanner m_Scanner;

    @Override
    public String globalInfo() {
        return "Reads all text data into a single string and returns that";
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    public void initialize(InputStream stream) {
        super.initialize(stream);
        this.m_Scanner = new Scanner(this.m_Stream, this.m_Encoding.charsetValue().name());
    }

    @Override
    protected String doNext() {
        StringBuilder result = new StringBuilder();
        try {
            String line;
            while ((line = this.m_Scanner.nextLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        catch (NoSuchElementException e) {
            this.m_Scanner.close();
            this.m_Scanner = null;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read from reader!", e);
            this.m_Scanner.close();
            this.m_Scanner = null;
            return null;
        }
        if (this.m_Scanner == null) {
            this.m_Stream = null;
        }
        return result.toString();
    }
}

