/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.io.FileUtils;
import adams.core.option.AbstractOptionHandler;
import adams.data.io.output.FlowWriter;
import adams.flow.core.Actor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;

public abstract class AbstractFlowWriter
extends AbstractOptionHandler
implements FlowWriter {
    private static final long serialVersionUID = -3547064795252689769L;

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    protected abstract OutputType getOutputType();

    @Override
    public boolean write(Actor content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean write(Actor content, String filename) {
        result = true;
        writer = null;
        output = null;
        try {
            switch (1.$SwitchMap$adams$data$io$output$AbstractFlowWriter$OutputType[this.getOutputType().ordinal()]) {
                case 1: {
                    result = this.doWrite(content, new File(filename));
                    ** break;
                }
                case 2: {
                    writer = new BufferedWriter(new FileWriter(filename));
                    result = this.doWrite(content, writer);
                    ** break;
                }
                case 3: {
                    output = new FileOutputStream(filename);
                    result = this.doWrite(content, output);
                    ** break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + (Object)this.getOutputType());
lbl19:
                    // 3 sources

                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                result = false;
                e.printStackTrace();
            }
            catch (Throwable var7_7) {
                FileUtils.closeQuietly(writer);
                FileUtils.closeQuietly(output);
                throw var7_7;
            }
            FileUtils.closeQuietly(writer);
            FileUtils.closeQuietly(output);
        }
        FileUtils.closeQuietly(writer);
        FileUtils.closeQuietly(output);
        return result;
    }

    @Override
    public boolean write(Actor content, OutputStream stream) {
        switch (this.getOutputType()) {
            case FILE: {
                throw new IllegalStateException("Only supports writing to files, not output streams!");
            }
            case STREAM: {
                return this.doWrite(content, stream);
            }
            case WRITER: {
                return this.doWrite(content, new OutputStreamWriter(stream));
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.getOutputType()));
    }

    @Override
    public boolean write(Actor content, Writer writer) {
        switch (this.getOutputType()) {
            case FILE: {
                throw new IllegalStateException("Only supports writing to files, not output streams!");
            }
            case STREAM: {
                return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
            }
            case WRITER: {
                return this.doWrite(content, writer);
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.getOutputType()));
    }

    protected boolean doWrite(Actor content, File file) {
        return false;
    }

    protected boolean doWrite(Actor content, Writer writer) {
        return false;
    }

    protected boolean doWrite(Actor content, OutputStream out) {
        return false;
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(FlowWriter.class);
    }

    public static enum OutputType {
        FILE,
        WRITER,
        STREAM;

    }
}

