/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.report.AbstractDatabaseConnectionReportFilter;
import adams.data.report.AbstractReportFilter;
import adams.data.report.MutableReportHandler;
import adams.data.report.PassThrough;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

public class FilteredReportFilter<T extends DataContainer>
extends AbstractDatabaseConnectionReportFilter<T> {
    private static final long serialVersionUID = 8646651693938769168L;
    protected AbstractFilter m_DataFilter;
    protected AbstractReportFilter m_ReportFilter;

    @Override
    public String globalInfo() {
        return "This filter first pushes the data through the provided data filter before applying the actual report filter. The updated filter obtained from the report filter is then replaces the report of the original data container.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-filter", "dataFilter", new adams.data.filter.PassThrough());
        this.m_OptionManager.add("report-filter", "reportFilter", new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setDataFilter(AbstractFilter value) {
        this.m_DataFilter = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractFilter getDataFilter() {
        return this.m_DataFilter;
    }

    public String dataFilterTipText() {
        return "The filter to apply to the data before pushing it through the report filter.";
    }

    public void setReportFilter(AbstractReportFilter value) {
        this.m_ReportFilter = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractReportFilter getReportFilter() {
        return this.m_ReportFilter;
    }

    public String reportFilterTipText() {
        return "The report filter to apply to the report.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_DataFilter instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_DataFilter)).setDatabaseConnection(this.getDatabaseConnection());
        }
        if (this.m_ReportFilter instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_ReportFilter)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        if (!(data instanceof MutableReportHandler)) {
            return data;
        }
        T filtered = this.m_DataFilter.filter(data);
        filtered = this.m_ReportFilter.filter(filtered);
        DataContainer result = (DataContainer)data.getClone();
        if (!((MutableReportHandler)((Object)result)).hasReport()) {
            return (T)result;
        }
        ((MutableReportHandler)((Object)result)).setReport(((Report)((ReportHandler)filtered).getReport()).getClone());
        return (T)result;
    }
}

