/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpreadSheetUtils {
    public static String[] split(String s, char delimiter) {
        return SpreadSheetUtils.split(s, delimiter, false);
    }

    public static String[] split(String s, char delimiter, boolean unquote) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                escaped = !escaped;
                current.append(c);
                continue;
            }
            if (c == delimiter) {
                if (escaped) {
                    current.append(c);
                    continue;
                }
                if (unquote) {
                    result.add(Utils.unDoubleQuote(current.toString()));
                } else {
                    result.add(current.toString());
                }
                current.delete(0, current.length());
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            if (unquote) {
                result.add(Utils.unDoubleQuote(current.toString()));
            } else {
                result.add(current.toString());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static List<String> createHeader(int numCols, String customCols) {
        ArrayList<String> result = new ArrayList<String>();
        if (!(customCols = customCols.trim()).isEmpty()) {
            result.addAll(Arrays.asList(customCols.split(",")));
        }
        while (result.size() < numCols) {
            result.add("Col-" + (result.size() + 1));
        }
        while (result.size() > numCols) {
            result.remove(result.size() - 1);
        }
        return result;
    }
}

