/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.statistics.AbstractArrayStatistic;

public class ArrayAndrewsCurves<T extends Number>
extends AbstractArrayStatistic<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -6455313543009954062L;
    protected int m_NumPoints;

    @Override
    public String globalInfo() {
        return "Generates Andrews Curves from array data.\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.AUTHOR, "C\u00e9sar Ignacio Garc\u00eda Osorio and Colin Fyfe");
        result.setValue(TechnicalInformation.Field.TITLE, "AN EXTENSION OF ANDREWS CURVES FOR DATA ANALYSIS");
        result.setValue(TechnicalInformation.Field.HTTP, "http://cib.uco.es/documents/Garcia03SIGEF.pdf");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-points", "numPoints", 100, 1, null);
    }

    public void setNumPoints(int value) {
        this.m_NumPoints = value;
        this.reset();
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points to generate for the curves.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        int i;
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(this.size(), this.m_NumPoints);
        String prefix = "t-";
        for (i = 0; i < this.m_NumPoints; ++i) {
            result.setHeader(i, prefix + (i + 1));
        }
        for (int r = 0; r < this.size(); ++r) {
            Number[] values = (Number[])this.get(r);
            for (i = 0; i < this.m_NumPoints; ++i) {
                double t = -Math.PI + Math.PI * 2 / (double)this.m_NumPoints * (double)i;
                double y = values[0].doubleValue() / Math.sqrt(2.0);
                for (int n = 1; n < values.length; ++n) {
                    if ((n + 1) % 2 == 0) {
                        y += values[n].doubleValue() * Math.sin(t * Math.ceil(n / 2));
                        continue;
                    }
                    y += values[n].doubleValue() * Math.cos(t * Math.ceil(n / 2));
                }
                result.setCell(r, i, y);
            }
        }
        return result;
    }
}

