/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.CloneHandler;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingLevel;
import adams.db.AbstractDatabaseConnection;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectionParameters
implements Serializable,
Comparable<ConnectionParameters>,
CloneHandler<ConnectionParameters> {
    private static final long serialVersionUID = -1414581492377334939L;
    public static final String PARAM_CLASS = "Class";
    public static final String PARAM_URL = "URL";
    public static final String PARAM_USER = "User";
    public static final String PARAM_PASSWORD = "Password";
    public static final String PARAM_LOGGINGLEVEL = "LoggingLevel";
    public static final String PARAM_CONNECTONSTARTUP = "ConnectOnStartup";
    public static final String PARAM_AUTOCOMMIT = "AutoCommit";
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected LoggingLevel m_LoggingLevel;
    protected boolean m_ConnectOnStartUp;
    protected boolean m_AutoCommit;

    public ConnectionParameters() {
        this.initialize();
    }

    protected void initialize() {
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = new BasePassword();
        this.m_LoggingLevel = LoggingLevel.OFF;
        this.m_ConnectOnStartUp = false;
        this.m_AutoCommit = false;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    public boolean getConnectOnStartUp() {
        return this.m_ConnectOnStartUp;
    }

    public boolean getAutoCommit() {
        return this.m_AutoCommit;
    }

    public Enumeration<String> parameters() {
        Vector<String> result = new Vector<String>();
        result.add(PARAM_CLASS);
        result.add(PARAM_URL);
        result.add(PARAM_USER);
        result.add(PARAM_PASSWORD);
        result.add(PARAM_LOGGINGLEVEL);
        result.add(PARAM_CONNECTONSTARTUP);
        result.add(PARAM_AUTOCOMMIT);
        return result.elements();
    }

    public String getParameter(String key) {
        if (key.equals(PARAM_CLASS)) {
            return this.getClass().getName();
        }
        if (key.equals(PARAM_URL)) {
            return this.m_URL;
        }
        if (key.equals(PARAM_USER)) {
            return this.m_User;
        }
        if (key.equals(PARAM_PASSWORD)) {
            return this.m_Password.stringValue();
        }
        if (key.equals(PARAM_LOGGINGLEVEL)) {
            return "" + (Object)((Object)this.m_LoggingLevel);
        }
        if (key.equals(PARAM_CONNECTONSTARTUP)) {
            return "" + this.m_ConnectOnStartUp;
        }
        if (key.equals(PARAM_AUTOCOMMIT)) {
            return "" + this.m_AutoCommit;
        }
        return null;
    }

    public void setParameter(String key, String value) {
        if (key.equals(PARAM_CLASS)) {
            // empty if block
        }
        if (key.equals(PARAM_URL)) {
            this.m_URL = value;
        } else if (key.equals(PARAM_USER)) {
            this.m_User = value;
        } else if (key.equals(PARAM_PASSWORD)) {
            this.m_Password = new BasePassword(value);
        } else if (key.equals(PARAM_LOGGINGLEVEL)) {
            this.m_LoggingLevel = LoggingLevel.valueOf(value);
        } else if (key.equals(PARAM_CONNECTONSTARTUP)) {
            this.m_ConnectOnStartUp = Boolean.parseBoolean(value);
        } else if (key.equals(PARAM_AUTOCOMMIT)) {
            this.m_AutoCommit = Boolean.parseBoolean(value);
        }
    }

    protected ConnectionParameters newInstance() {
        return new ConnectionParameters();
    }

    @Override
    public ConnectionParameters getClone() {
        ConnectionParameters result = this.newInstance();
        Enumeration<String> keys = this.parameters();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.setParameter(key, this.getParameter(key));
        }
        return result;
    }

    @Override
    public int compareTo(ConnectionParameters o) {
        if (o == null) {
            return 1;
        }
        Enumeration<String> keys = this.parameters();
        int result = 0;
        while (result == 0 && keys.hasMoreElements()) {
            String key = keys.nextElement();
            String oThis = this.getParameter(key);
            String oOther = o.getParameter(key);
            if (oOther == null) {
                result = 1;
                continue;
            }
            if (!(oThis instanceof Comparable)) continue;
            result = ((Comparable)((Object)oThis)).compareTo(oOther);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionParameters) {
            return this.compareTo((ConnectionParameters)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return new String(this.m_URL + "\t" + this.m_User + "\t" + this.m_Password).hashCode();
    }

    public String toString() {
        return this.m_URL.replaceAll(".*\\/\\/", "");
    }

    public AbstractDatabaseConnection toDatabaseConnection(Class dbcon) {
        AbstractDatabaseConnection result;
        try {
            result = (AbstractDatabaseConnection)dbcon.newInstance();
            result.setURL(this.getURL());
            result.setUser(this.getUser());
            result.setPassword(this.getPassword());
            result.setLoggingLevel(this.getLoggingLevel());
            result.setConnectOnStartUp(this.getConnectOnStartUp());
            result.setAutoCommit(this.getAutoCommit());
        }
        catch (Exception e) {
            System.err.println("Failed to create database connection object:");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static ConnectionParameters forName(String classname) {
        ConnectionParameters result;
        try {
            result = (ConnectionParameters)Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            result = new ConnectionParameters();
        }
        return result;
    }
}

