/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.javadoc;

import adams.core.ClassLocator;
import adams.core.option.AbstractOption;
import adams.core.option.CommandlineHelpProducer;
import adams.core.option.OptionHandler;
import adams.doc.javadoc.Javadoc;
import java.util.List;

public class OptionHandlerJavadoc
extends Javadoc {
    private static final long serialVersionUID = 6411696179436469435L;
    public static final String OPTIONS_STARTTAG = "<!-- options-start -->";
    public static final String OPTIONS_ENDTAG = "<!-- options-end -->";
    protected boolean m_Prolog;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StartTag = new String[1];
        this.m_EndTag = new String[1];
        this.m_IsBlock = new boolean[1];
        this.m_StartTag[0] = OPTIONS_STARTTAG;
        this.m_EndTag[0] = OPTIONS_ENDTAG;
        this.m_IsBlock[0] = true;
        this.m_Prolog = true;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("noprolog", "Prolog", false);
    }

    public void setProlog(boolean value) {
        this.m_Prolog = value;
    }

    public boolean getProlog() {
        return this.m_Prolog;
    }

    public String PrologTipText() {
        return "Controls the 'Valid options are...' prolog in the Javadoc.";
    }

    protected String generateJavadoc(String option) {
        String[] lines = option.split("\n");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = this.toHTML(lines[i]);
            if (i > 0) {
                line = line.replaceAll("\\t", "        ");
            }
            result.append(line + "\n");
        }
        return result.toString();
    }

    @Override
    protected String generateJavadoc(int index) throws Exception {
        String result = "";
        if (index == 0) {
            if (!this.canInstantiateClass()) {
                return result;
            }
            if (!ClassLocator.hasInterface(OptionHandler.class, this.getInstance().getClass())) {
                throw new Exception("Class '" + this.getClassname() + "' is not an OptionHandler!");
            }
            OptionHandler handler = (OptionHandler)this.getInstance();
            List<AbstractOption> options = handler.getOptionManager().getOptionsList();
            if (options.size() == 0) {
                return result;
            }
            if (this.getProlog()) {
                result = "Valid options are: <br>\n\n";
            }
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < options.size(); ++i) {
                CommandlineHelpProducer help = new CommandlineHelpProducer();
                buffer.append("<pre>");
                buffer.append(this.generateJavadoc(((StringBuilder)help.doProduce(options.get(i))).toString()));
                buffer.append("</pre>\n\n");
            }
            result = result + buffer.toString();
            if (this.getUseStars()) {
                result = this.indent(result, 1, "* ");
            }
        }
        return result;
    }

    public static void main(String[] args) {
        OptionHandlerJavadoc.runJavadoc(OptionHandlerJavadoc.class, args);
    }
}

