/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.container.AbstractContainer;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public abstract class AbstractContainerUpdater
extends SubProcess {
    private static final long serialVersionUID = 7140175689043000123L;
    public static final String BACKUP_OUTPUT = "output";
    protected String m_ContainerValueName;
    protected Token m_OutputToken;

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    protected void setContainerValueName(String value) {
        this.m_ContainerValueName = value;
        this.reset();
    }

    protected String getContainerValueName() {
        return this.m_ContainerValueName;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{AbstractContainer.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_CurrentToken = token;
        this.m_OutputToken = null;
    }

    protected Object getContainerValue(AbstractContainer cont) {
        if (cont.hasValue(this.m_ContainerValueName)) {
            return cont.getValue(this.m_ContainerValueName);
        }
        throw new IllegalStateException("Container value not present: " + this.m_ContainerValueName);
    }

    @Override
    protected String doExecute() {
        String result = null;
        AbstractActor first = this.firstActive();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("first active actor: " + first.getFullName());
        }
        AbstractContainer cont = null;
        boolean processed = false;
        if (first != null && first instanceof InputConsumer) {
            cont = (AbstractContainer)this.m_CurrentToken.getPayload();
            Object input = this.getContainerValue(cont);
            ((InputConsumer)((Object)first)).input(new Token(input));
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("input: " + input);
            }
            try {
                result = this.m_Director.execute();
                processed = true;
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute director", e);
            }
        }
        if (processed) {
            if (this.m_OutputTokens.size() == 1) {
                try {
                    Object output = ((Token)this.m_OutputTokens.get(0)).getPayload();
                    AbstractContainer contNew = cont.getClone();
                    contNew.setValue(this.m_ContainerValueName, output);
                    this.m_OutputToken = new Token(contNew);
                }
                catch (Exception e) {
                    result = this.handleException("Failed to generate new container: ", e);
                    this.m_OutputToken = null;
                }
            } else {
                result = "Last active sub-actor did not produce exactly one output: " + this.m_OutputTokens.size();
            }
        }
        this.m_OutputTokens.clear();
        return result;
    }

    @Override
    protected String postExecute() {
        String result = super.postExecute();
        if (this.isStopped()) {
            this.m_OutputToken = null;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

