/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.flow.control.Tee;
import adams.flow.core.Compatibility;
import adams.flow.core.Token;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDataContainerFileChecker<T extends DataContainer>
extends Tee {
    private static final long serialVersionUID = 4924674489892108627L;
    public static final String BACKUP_TEMPLIST = "temp list";
    public static final String BACKUP_FINALLIST = "final list";
    protected Hashtable<File, FileInfo> m_BlackListTemp;
    protected Hashtable<File, FileInfo> m_BlackListFinal;
    protected AbstractDataContainerReader<T> m_Reader;
    protected AbstractDataContainerReader<T> m_ActualReader;
    protected BaseDateTime m_ExpiryInterval;
    protected BaseTime m_CheckInterval;
    protected PlaceholderFile m_Log;
    protected transient DateFormat m_Formatter;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", this.getDefaultReader());
        this.m_OptionManager.add("expiry-interval", "expiryInterval", new BaseDateTime("START +24 HOUR"));
        this.m_OptionManager.add("check-interval", "checkInterval", new BaseTime("START +15 MINUTE"));
        this.m_OptionManager.add("log", "log", new PlaceholderFile("."));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BlackListTemp = new Hashtable();
        this.m_BlackListFinal = new Hashtable();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_BlackListTemp.clear();
        this.m_BlackListFinal.clear();
        this.m_ActualReader = null;
    }

    protected synchronized DateFormat getFormatter() {
        if (this.m_Formatter == null) {
            this.m_Formatter = DateUtils.getTimestampFormatter();
        }
        return this.m_Formatter;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_TEMPLIST);
        this.pruneBackup(BACKUP_FINALLIST);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_TEMPLIST, this.m_BlackListTemp);
        result.put(BACKUP_TEMPLIST, this.m_BlackListFinal);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_TEMPLIST)) {
            this.m_BlackListTemp = (Hashtable)state.get(BACKUP_TEMPLIST);
            state.remove(BACKUP_TEMPLIST);
        }
        if (state.containsKey(BACKUP_FINALLIST)) {
            this.m_BlackListTemp = (Hashtable)state.get(BACKUP_FINALLIST);
            state.remove(BACKUP_FINALLIST);
        }
        super.restoreState(state);
    }

    protected abstract AbstractDataContainerReader<T> getDefaultReader();

    public void setReader(AbstractDataContainerReader<T> value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractDataContainerReader<T> getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the files being passed through.";
    }

    public void setExpiryInterval(BaseDateTime value) {
        this.m_ExpiryInterval = value;
        this.reset();
    }

    public BaseDateTime getExpiryInterval() {
        return this.m_ExpiryInterval;
    }

    public String expiryIntervalTipText() {
        return "The time interval before black-listed items are moved from the temporary list to the final list; requires the keyword 'START' in the expression.";
    }

    public void setCheckInterval(BaseTime value) {
        this.m_CheckInterval = value;
        this.reset();
    }

    public BaseTime getCheckInterval() {
        return this.m_CheckInterval;
    }

    public String checkIntervalTipText() {
        return "The time interval after which black-listed items in the temporary list are checked again whether they finally load correctly; requires the keyword 'START' in the expression.";
    }

    public void setLog(PlaceholderFile value) {
        this.m_Log = value;
        this.reset();
    }

    public PlaceholderFile getLog() {
        return this.m_Log;
    }

    public String logTipText() {
        return "The log file to write the files to that expired from the final black-list, ie, never being loaded correctly; log gets ignored if pointing to a directory.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    protected String setUpTeeActors() {
        String result = null;
        Compatibility comp = new Compatibility();
        Class[] accepts = new Class[]{String.class, File.class};
        if (!comp.isCompatible(accepts, this.m_Actors.accepts())) {
            result = "Accepted input and tee actor are not compatible!";
        }
        return result;
    }

    protected boolean isValid(File file) {
        boolean result;
        block4: {
            result = true;
            if (this.m_ActualReader == null) {
                this.m_ActualReader = this.m_Reader.shallowCopy(true);
            }
            try {
                this.m_ActualReader.setInput(new PlaceholderFile(file));
                List<T> containers = this.m_ActualReader.read();
                result = containers != null && containers.size() > 0;
            }
            catch (Exception e) {
                result = false;
                if (!this.isLoggingEnabled()) break block4;
                this.getLogger().info("Failed to read '" + file + "': " + e);
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Reading of '" + file + "' " + (result ? "succeeded" : "failed"));
        }
        return result;
    }

    protected void logExpired(File file, FileInfo info, Date expired) {
        if (this.m_Log.isDirectory()) {
            return;
        }
        if (!file.exists()) {
            FileUtils.writeToFile(this.m_Log.getAbsolutePath(), (Object)"File\tAdded\tExpired\n", false);
        }
        FileUtils.writeToFile(this.m_Log.getAbsolutePath(), (Object)(file + "\t" + this.getFormatter().format(info.getAddedTimestamp()) + "\t" + this.getFormatter().format(expired) + "\n"), true);
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return false;
    }

    @Override
    protected String doExecute() {
        int i;
        String result = null;
        boolean isArray = this.m_InputToken.getPayload() instanceof File[] || this.m_InputToken.getPayload() instanceof String[];
        boolean isFile = this.m_InputToken.getPayload() instanceof File[] || this.m_InputToken.getPayload() instanceof File;
        File[] files = FileUtils.toPlaceholderFileArray(this.m_InputToken.getPayload());
        Date now = new Date();
        ArrayList<File> valid = new ArrayList<File>();
        BaseDateTime expired = (BaseDateTime)this.m_ExpiryInterval.getClone();
        for (i = 0; i < files.length; ++i) {
            FileInfo item;
            if (this.m_BlackListFinal.containsKey(files[i])) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("in final list (skipped): " + files[i]);
                continue;
            }
            if (this.m_BlackListTemp.containsKey(files[i])) {
                item = this.m_BlackListTemp.get(files[i]);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("in temp list (checking): " + files[i]);
                }
                if (now.compareTo(item.getCheckTimestamp()) != 1) continue;
                if (this.isValid(files[i])) {
                    valid.add(files[i]);
                    this.m_BlackListTemp.remove(files[i]);
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("is valid, removed from temp list: " + files[i]);
                    continue;
                }
                expired.setStart(item.getAddedTimestamp());
                if (now.compareTo(expired.dateValue()) == 1) {
                    this.m_BlackListTemp.remove(files[i]);
                    this.m_BlackListFinal.put(files[i], item);
                    this.logExpired(files[i], item, now);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("moved to final list: " + files[i]);
                    }
                    if ((result = isFile ? this.processInput(new Token(files[i].getAbsoluteFile())) : this.processInput(new Token(files[i].getAbsolutePath()))) == null) continue;
                    result = this.getErrorHandler().handleError(this, "tee", result);
                    continue;
                }
                item.updateCheckTimestamp(this.m_CheckInterval.getValue());
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("kept in temp list: " + files[i]);
                continue;
            }
            if (this.isValid(files[i])) {
                valid.add(files[i]);
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("is valid: " + files[i]);
                continue;
            }
            item = new FileInfo(this.m_CheckInterval.getValue());
            this.m_BlackListTemp.put(files[i], item);
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("added to temp list: " + files[i]);
        }
        if (valid.size() > 0) {
            files = new File[valid.size()];
            String[] filesStr = new String[valid.size()];
            for (i = 0; i < valid.size(); ++i) {
                if (isFile) {
                    files[i] = (File)valid.get(i);
                    continue;
                }
                filesStr[i] = ((File)valid.get(i)).getAbsolutePath();
            }
            this.m_OutputToken = isArray ? (isFile ? new Token(files) : new Token(filesStr)) : (isFile ? new Token(files[0]) : new Token(filesStr[0]));
        }
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_BlackListTemp != null) {
            this.m_BlackListTemp.clear();
            this.m_BlackListTemp = null;
        }
        if (this.m_BlackListFinal != null) {
            this.m_BlackListFinal.clear();
            this.m_BlackListFinal = null;
        }
        if (this.m_ActualReader != null) {
            this.m_ActualReader.destroy();
            this.m_ActualReader = null;
        }
        this.m_Formatter = null;
    }

    public static class FileInfo
    implements Serializable {
        private static final long serialVersionUID = -2652218858666502429L;
        protected Date m_AddedTimestamp = new Date();
        protected Date m_CheckTimestamp;

        public FileInfo(String timeDiff) {
            this.updateCheckTimestamp(timeDiff);
        }

        public Date getAddedTimestamp() {
            return this.m_AddedTimestamp;
        }

        public Date getCheckTimestamp() {
            return this.m_CheckTimestamp;
        }

        public void updateCheckTimestamp(String timeDiff) {
            BaseDateTime check = new BaseDateTime();
            if (!check.isValid(timeDiff)) {
                this.m_CheckTimestamp = BaseDateTime.infinityFuture().dateValue();
                throw new IllegalArgumentException("Incorrect time format '" + timeDiff + "', " + "check documentation on " + BaseTime.class.getName() + ".");
            }
            check.setValue(timeDiff);
            check.setStart(new Date());
            this.m_CheckTimestamp = check.dateValue();
        }

        public String toString() {
            return "added=" + this.m_AddedTimestamp + ", check=" + this.m_CheckTimestamp;
        }
    }
}

