/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.CleanUpHandler;
import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.flow.control.AbstractControlActor;

public abstract class AbstractDirector
extends LoggingObject
implements CleanUpHandler,
StoppableWithFeedback,
FlowPauseStateListener {
    private static final long serialVersionUID = -1634725837304059804L;
    protected AbstractControlActor m_ControlActor;
    protected String m_LoggingPrefix;
    protected boolean m_Stopped;
    protected boolean m_Stopping;
    protected boolean m_Paused;
    protected boolean m_Flushing;

    public AbstractDirector() {
        this.initialize();
    }

    protected void initialize() {
        this.m_LoggingPrefix = this.getClass().getSimpleName() + "/" + this.hashCode();
    }

    public void updatePrefix() {
        this.m_LoggingPrefix = this.m_ControlActor != null ? this.m_ControlActor.getFullName() + "." + this.getClass().getSimpleName() + "/" + this.hashCode() : this.getClass().getSimpleName() + "/" + this.hashCode();
    }

    @Override
    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger(this.m_LoggingPrefix);
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
    }

    protected String handleException(String msg, Throwable t) {
        return Utils.handleException(this, msg, t, !this.hasControlActor() || this.m_ControlActor.getSilent());
    }

    public void setControlActor(AbstractControlActor value) {
        this.m_ControlActor = value;
        this.updatePrefix();
    }

    public AbstractControlActor getControlActor() {
        return this.m_ControlActor;
    }

    public boolean hasControlActor() {
        return this.m_ControlActor != null;
    }

    protected Variables getVariables() {
        if (this.hasControlActor()) {
            return this.m_ControlActor.getVariables();
        }
        return new Variables();
    }

    public abstract String execute();

    public void pauseExecution() {
        this.m_Paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        while (this.isPaused() && !this.isStopped() && !this.isStopping()) {
            try {
                AbstractDirector abstractDirector = this;
                synchronized (abstractDirector) {
                    this.wait(500L);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public boolean isPaused() {
        return this.m_Paused;
    }

    public void flushExecution() {
        this.m_Flushing = true;
    }

    public boolean isFlushing() {
        return this.m_Flushing;
    }

    @Override
    public void stopExecution() {
        this.m_Stopping = true;
        this.getLogger().info("stop called");
        if (this.hasControlActor()) {
            for (int i = this.m_ControlActor.size() - 1; i >= 0; --i) {
                if (this.m_ControlActor.get(i).getSkip()) continue;
                this.m_ControlActor.get(i).stopExecution();
            }
        }
        this.m_Stopped = true;
        this.m_Stopping = false;
    }

    @Override
    public boolean isStopped() {
        return this.m_Stopped;
    }

    public boolean isStopping() {
        return this.m_Stopping;
    }

    public boolean isFinished() {
        return true;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void flowPauseStateChanged(FlowPauseStateEvent e) {
        this.m_Paused = e.getType() == FlowPauseStateEvent.Type.PAUSED;
    }

    public String toString() {
        return this.getClass().getName() + "/" + this.hashCode() + ": " + (this.hasControlActor() ? "--" : this.m_ControlActor.getFullName());
    }
}

