/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Counting;
import adams.flow.control.Tee;
import adams.flow.core.Token;

public class ConditionalTee
extends Tee
implements BooleanConditionSupporter {
    private static final long serialVersionUID = -5532257363818440415L;
    protected BooleanCondition m_Condition;

    @Override
    public String globalInfo() {
        return "Tees off the tokens if the condition evaluates to 'true'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new Counting());
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_Condition.getQuickInfo();
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The boolean condition to evaluate.";
    }

    protected boolean canFire() {
        return this.m_Condition.evaluate(this, this.m_InputToken);
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token) && this.canFire();
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Condition.setUp(this);
        }
        return result;
    }

    @Override
    public void stopExecution() {
        this.m_Condition.stopExecution();
        super.stopExecution();
    }
}

