/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Counting;
import adams.flow.control.Trigger;
import adams.flow.core.Token;

public class ConditionalTrigger
extends Trigger
implements BooleanConditionSupporter {
    private static final long serialVersionUID = 4568526647666412543L;
    protected BooleanCondition m_Condition;

    @Override
    public String globalInfo() {
        return "Executes the tee-actor whenever a token gets passed through. In contrast to the Tee actor, it doesn't feed the tee-actor with the current token.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new Counting());
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_Condition.getQuickInfo();
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The boolean condition to evaluate.";
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Condition.setUp(this);
        }
        return result;
    }

    @Override
    protected String processInput(Token token) {
        String result = null;
        try {
            if (this.m_Condition.evaluate(this, token)) {
                result = super.processInput(token);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to trigger: ", e);
        }
        return result;
    }

    @Override
    public void stopExecution() {
        this.m_Condition.stopExecution();
        super.stopExecution();
    }
}

