/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.core.ControlActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.BooleanExpressionText;
import adams.parser.GrammarSupplier;
import java.util.Hashtable;

public class Continue
extends AbstractTransformer
implements ControlActor,
GrammarSupplier,
BooleanConditionSupporter {
    private static final long serialVersionUID = -2318544907798411076L;
    public static final String BACKUP_INPUT = "input";
    protected BooleanCondition m_Condition;

    @Override
    public String globalInfo() {
        return "Blocks the propagation of tokens if the condition evaluates to 'true', therefore acts like the 'continue' control statement.\nIn case of integer or double tokens that arrive at the input, these can be accessed in the expression via 'X'.\n\nThe following grammar is used for evaluating the boolean expressions (depends on the selected condition):\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        if (this.m_Condition instanceof GrammarSupplier) {
            return ((GrammarSupplier)((Object)this.m_Condition)).getGrammar();
        }
        return null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", this.getDefaultCondition());
    }

    protected BooleanCondition getDefaultCondition() {
        Expression result = new Expression();
        result.setExpression(new BooleanExpressionText("false"));
        return result;
    }

    @Override
    public String getQuickInfo() {
        return this.m_Condition.getQuickInfo();
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition that determines whether to drop the token (ie continue) (evaluates to 'true') or not (evaluates to 'false').";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Condition.setUp(this);
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_OutputToken = !this.m_Condition.evaluate(this, this.m_InputToken) ? this.m_InputToken : null;
        return result;
    }

    @Override
    public void stopExecution() {
        this.m_Condition.stopExecution();
        super.stopExecution();
    }
}

