/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import java.util.HashSet;
import java.util.Hashtable;

public class InputOutputListener
extends SubProcess {
    private static final long serialVersionUID = 5975989766824652946L;
    public static final String BACKUP_CALLABLEINPUT = "callable input";
    public static final String BACKUP_CALLABLEOUTPUT = "callable output";
    public static final String BACKUP_CONFIGURED = "configured";
    protected boolean m_OnInput;
    protected CallableActorReference m_InputDestination;
    protected boolean m_OnOutput;
    protected CallableActorReference m_OutputDestination;
    protected AbstractActor m_CallableInput;
    protected AbstractActor m_CallableOutput;
    protected boolean m_Configured;
    protected CallableActorHelper m_Helper;

    @Override
    public String globalInfo() {
        return "Listens to the input/output tokens of the sub-actors, sending them to callable actors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("on-input", "onInput", false);
        this.m_OptionManager.add("input-destination", "inputDestination", new CallableActorReference());
        this.m_OptionManager.add("on-output", "onOutput", false);
        this.m_OptionManager.add("output-destination", "outputDestination", new CallableActorReference());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CallableInput = null;
        this.m_CallableOutput = null;
        this.m_Configured = false;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "onInput", this.m_OnInput ? "on" : "off", "input: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "inputDestination", this.m_InputDestination, ", input-dest: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "onOutput", this.m_OnOutput ? "on" : "off", ", output: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "outputDestination", this.m_OutputDestination, ", output-dest: ");
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setOnInput(boolean value) {
        this.m_OnInput = value;
        this.reset();
    }

    public boolean getOnInput() {
        return this.m_OnInput;
    }

    public String onInputTipText() {
        return "If enabled, input tokens are forwarded to the specified callable actor.";
    }

    public void setInputDestination(CallableActorReference value) {
        this.m_InputDestination = value;
        this.reset();
    }

    public CallableActorReference getInputDestination() {
        return this.m_InputDestination;
    }

    public String inputDestinationTipText() {
        return "The callable actor to send the input tokens to.";
    }

    public void setOnOutput(boolean value) {
        this.m_OnOutput = value;
        this.reset();
    }

    public boolean getOnOutput() {
        return this.m_OnOutput;
    }

    public String onOutputTipText() {
        return "If enabled, output tokens are forwarded to the specified callable actor.";
    }

    public void setOutputDestination(CallableActorReference value) {
        this.m_OutputDestination = value;
        this.reset();
    }

    public CallableActorReference getOutputDestination() {
        return this.m_OutputDestination;
    }

    public String outputDestinationTipText() {
        return "The callable actor to send the output tokens to.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEINPUT);
        this.pruneBackup(BACKUP_CALLABLEOUTPUT);
        this.pruneBackup(BACKUP_CONFIGURED);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CallableInput != null) {
            result.put(BACKUP_CALLABLEINPUT, this.m_CallableInput);
        }
        if (this.m_CallableOutput != null) {
            result.put(BACKUP_CALLABLEOUTPUT, this.m_CallableOutput);
        }
        result.put(BACKUP_CONFIGURED, this.m_Configured);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEINPUT)) {
            this.m_CallableInput = (AbstractActor)state.get(BACKUP_CALLABLEINPUT);
            state.remove(BACKUP_CALLABLEINPUT);
        }
        if (state.containsKey(BACKUP_CALLABLEOUTPUT)) {
            this.m_CallableOutput = (AbstractActor)state.get(BACKUP_CALLABLEOUTPUT);
            state.remove(BACKUP_CALLABLEOUTPUT);
        }
        if (state.containsKey(BACKUP_CONFIGURED)) {
            this.m_Configured = (Boolean)state.get(BACKUP_CONFIGURED);
            state.remove(BACKUP_CONFIGURED);
        }
    }

    protected String setUpCallableActors() {
        HashSet<String> variables;
        String result = null;
        this.m_CallableInput = this.m_Helper.findCallableActorRecursive(this, this.getInputDestination());
        if (this.m_CallableInput == null) {
            this.getLogger().warning("Couldn't find callable actor (input destination) '" + this.getInputDestination() + "'!");
        } else if (!(this.m_CallableInput instanceof InputConsumer)) {
            result = "Callable actor (input destination) '" + this.getInputDestination() + "' does not accept input!";
        } else {
            variables = this.findVariables(this.m_CallableInput);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener(this);
            }
            if (this.getErrorHandler() != this) {
                ActorUtils.updateErrorHandler(this.m_CallableInput, this.getErrorHandler(), this.isLoggingEnabled());
            }
        }
        if (result == null) {
            this.m_CallableOutput = this.m_Helper.findCallableActorRecursive(this, this.getOutputDestination());
            if (this.m_CallableOutput == null) {
                this.getLogger().warning("Couldn't find callable actor (output destination) '" + this.getOutputDestination() + "'!");
            } else if (!(this.m_CallableOutput instanceof InputConsumer)) {
                result = "Callable actor (output destination) '" + this.getOutputDestination() + "' does not accept input!";
            } else {
                variables = this.findVariables(this.m_CallableOutput);
                this.m_DetectedVariables.addAll(variables);
                if (this.m_DetectedVariables.size() > 0) {
                    this.getVariables().addVariableChangeListener(this);
                }
                if (this.getErrorHandler() != this) {
                    ActorUtils.updateErrorHandler(this.m_CallableOutput, this.getErrorHandler(), this.isLoggingEnabled());
                }
            }
        }
        this.m_Configured = result == null;
        return result;
    }

    @Override
    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("inputDestination")) == null && (variable = this.getOptionManager().getVariableForProperty("outputDestination")) == null) {
            this.setUpCallableActors();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void input(Token token) {
        if (this.m_OnInput) {
            String msg;
            if (!this.m_Configured && (msg = this.setUpCallableActors()) != null) {
                throw new IllegalStateException("Failed to configure callable actor(s):\n" + msg);
            }
            if (this.m_CallableInput != null && !this.m_CallableInput.getSkip() && !this.m_CallableInput.isStopped()) {
                AbstractActor abstractActor = this.m_CallableInput;
                synchronized (abstractActor) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable actor (input dest) - start: " + this.m_CallableInput);
                    }
                    ((InputConsumer)((Object)this.m_CallableInput)).input(token);
                    msg = this.m_CallableInput.execute();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable actor (input dest) - end: " + msg);
                    }
                }
            }
        }
        super.input(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token output() {
        Token result = super.output();
        if (this.m_OnOutput) {
            String msg;
            if (!this.m_Configured && (msg = this.setUpCallableActors()) != null) {
                throw new IllegalStateException("Failed to configure callable actor(s):\n" + msg);
            }
            if (this.m_CallableOutput != null && !this.m_CallableOutput.getSkip() && !this.m_CallableOutput.isStopped()) {
                AbstractActor abstractActor = this.m_CallableOutput;
                synchronized (abstractActor) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable actor (output dest) - start: " + this.m_CallableOutput);
                    }
                    ((InputConsumer)((Object)this.m_CallableOutput)).input(result);
                    msg = this.m_CallableOutput.execute();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable actor (output dest) - end: " + msg);
                    }
                }
            }
        }
        return result;
    }
}

