/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractDisplay;
import adams.flow.core.ControlActor;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MissionControl
extends AbstractDisplay
implements ControlActor,
FlowPauseStateListener {
    private static final long serialVersionUID = -6030616525436078513L;
    protected String m_Text;

    @Override
    public String globalInfo() {
        return "Displays a control panel for pausing/resuming/stopping the flow.\nUseful when executing flows from command-line with the flow runner, offering a minimal control interface.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("text", "text", "");
    }

    public void setText(String value) {
        this.m_Text = value;
        this.reset();
    }

    public String getText() {
        return this.m_Text;
    }

    public String textTipText() {
        return "The (optional) text to display in the control panel.";
    }

    @Override
    protected int getDefaultX() {
        return -3;
    }

    @Override
    protected int getDefaultWidth() {
        return 100;
    }

    @Override
    protected int getDefaultHeight() {
        return 56;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "text", this.m_Text.isEmpty() ? "-none-" : this.m_Text, ", text: ");
        return result;
    }

    @Override
    public void clearPanel() {
    }

    @Override
    protected BasePanel newPanel() {
        ControlPanel result = new ControlPanel(this);
        return result;
    }

    @Override
    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MissionControl.this.m_CreateFrame && !MissionControl.this.m_Frame.isVisible()) {
                    MissionControl.this.m_Frame.setVisible(true);
                }
                ((ControlPanel)MissionControl.this.m_Panel).updateButtons();
                AbstractActor abstractActor = MissionControl.this.m_Self;
                synchronized (abstractActor) {
                    MissionControl.this.m_Self.notifyAll();
                }
                MissionControl.this.m_Updating = false;
            }
        };
        return result;
    }

    @Override
    public void flowPauseStateChanged(FlowPauseStateEvent e) {
        if (this.m_Panel != null) {
            ((ControlPanel)this.m_Panel).updateButtons();
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.getRoot() instanceof Flow) {
                Flow flow = (Flow)this.getRoot();
                flow.getPauseStateManager().addListener(this);
            } else {
                result = "Root is not a Flow actor? Cannot register pause state listener!";
            }
        }
        return result;
    }

    @Override
    public void wrapUp() {
        if (this.getRoot() instanceof Flow) {
            Flow flow = (Flow)this.getRoot();
            flow.getPauseStateManager().removeListener(this);
        }
        this.cleanUpGUI();
        super.wrapUp();
    }

    public static class ControlPanel
    extends BasePanel {
        private static final long serialVersionUID = 1725406518546756466L;
        protected MissionControl m_Owner;
        protected JPanel m_PanelText;
        protected JLabel m_LabelText;
        protected JButton m_ButtonPause;
        protected JButton m_ButtonResume;
        protected JButton m_ButtonStop;

        public ControlPanel(MissionControl owner) {
            this.m_Owner = owner;
            this.m_LabelText.setText(this.m_Owner.getText());
            this.m_PanelText.setVisible(!this.m_Owner.getText().trim().isEmpty());
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelText = new JPanel(new FlowLayout(0));
            this.m_PanelText.setVisible(false);
            this.add((Component)this.m_PanelText, "North");
            this.m_LabelText = new JLabel("");
            this.m_PanelText.add(this.m_LabelText);
            JPanel panel = new JPanel(new GridLayout(1, 3));
            this.add((Component)panel, "Center");
            this.m_ButtonPause = new JButton(GUIHelper.getIcon("pause.gif"));
            this.m_ButtonPause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.getOwner().getRoot() instanceof Flow) {
                        Flow flow = (Flow)this.getOwner().getRoot();
                        flow.pauseExecution();
                    }
                }
            });
            panel.add(this.m_ButtonPause);
            this.m_ButtonResume = new JButton(GUIHelper.getIcon("resume.gif"));
            this.m_ButtonResume.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.getOwner().getRoot() instanceof Flow) {
                        Flow flow = (Flow)this.getOwner().getRoot();
                        flow.resumeExecution();
                    }
                }
            });
            panel.add(this.m_ButtonResume);
            this.m_ButtonStop = new JButton(GUIHelper.getIcon("stop_blue.gif"));
            this.m_ButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.getOwner().getRoot().stopExecution();
                }
            });
            panel.add(this.m_ButtonStop);
        }

        public MissionControl getOwner() {
            return this.m_Owner;
        }

        public void updateButtons() {
            if (this.getOwner().getRoot() instanceof Flow) {
                Flow flow = (Flow)this.getOwner().getRoot();
                this.m_ButtonPause.setEnabled(!flow.isPaused() && !flow.isStopped());
                this.m_ButtonResume.setEnabled(flow.isPaused() && !flow.isStopped());
                this.m_ButtonStop.setEnabled(!flow.isStopped());
            }
        }
    }
}

