/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ControlActor;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class Sleep
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = -3383735680425581504L;
    protected int m_Interval;

    @Override
    public String globalInfo() {
        return "Waits for a fixed amount of milli-seconds.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interval", "interval", 1000);
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval in milli-seconds to wait before continuing with the execution.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "interval", this.m_Interval) + "ms";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        try {
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                this.wait(this.m_Interval);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            result = this.handleException("Failed to sleep:", e);
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        try {
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                this.m_Self.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }
}

