/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.container.TimingContainer;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.TimedActor;
import adams.flow.core.Token;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.commons.lang.time.StopWatch;

public class TimedSubProcess
extends SubProcess
implements TimedActor {
    private static final long serialVersionUID = 85320778988733777L;
    public static final String BACKUP_CALLABLEACTOR = "callable actor";
    public static final String BACKUP_CONFIGURED = "configured";
    protected boolean m_TimingEnabled;
    protected String m_Prefix;
    protected CallableActorReference m_CallableName;
    protected AbstractActor m_CallableActor;
    protected boolean m_Configured;
    protected CallableActorHelper m_Helper;
    protected boolean m_Optional;
    protected transient StopWatch m_StopWatch;

    @Override
    public String globalInfo() {
        return super.globalInfo() + "\n" + "Times how long the sub-flow execution takes and sends the time " + "in milli-seconds (as double) in a " + TimingContainer.class.getName() + " container to the specified callable actor.";
    }

    @Override
    public Class getConditionalEquivalent() {
        return null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timing-enabled", "timingEnabled", true);
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("callable", "callableName", new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Configured = false;
        this.m_StopWatch = null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setTimingEnabled(boolean value) {
        this.m_TimingEnabled = value;
        this.reset();
    }

    public boolean getTimingEnabled() {
        return this.m_TimingEnabled;
    }

    public String timingEnabledTipText() {
        return "If enabled, then the actors performs timing on its execution.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to store in the timing container.";
    }

    @Override
    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    @Override
    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    @Override
    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    @Override
    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    @Override
    public boolean getOptional() {
        return this.m_Optional;
    }

    @Override
    public String optionalTipText() {
        return "If enabled, then the callable actor is optional, ie no error is raised if not found, merely ignored.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "callableName", this.m_CallableName);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "prefix", this.m_Prefix.isEmpty() ? "-none-" : this.m_Prefix, ". prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "optional", this.m_Optional, "optional", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "timingEnabled", this.m_TimingEnabled, "enabled", ", ");
        return result;
    }

    protected AbstractActor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive(this, this.getCallableName());
    }

    @Override
    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    @Override
    public AbstractActor getCallableActor() {
        return this.m_CallableActor;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEACTOR);
        this.pruneBackup(BACKUP_CONFIGURED);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CallableActor != null) {
            result.put(BACKUP_CALLABLEACTOR, this.m_CallableActor);
        }
        result.put(BACKUP_CONFIGURED, this.m_Configured);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEACTOR)) {
            this.m_CallableActor = (AbstractActor)state.get(BACKUP_CALLABLEACTOR);
            state.remove(BACKUP_CALLABLEACTOR);
        }
        if (state.containsKey(BACKUP_CONFIGURED)) {
            this.m_Configured = (Boolean)state.get(BACKUP_CONFIGURED);
            state.remove(BACKUP_CONFIGURED);
        }
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_Configured = true;
        if (!this.m_TimingEnabled) {
            return result;
        }
        this.m_CallableActor = this.findCallableActor();
        if (this.m_CallableActor == null) {
            if (!this.m_Optional) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                this.getLogger().info("Callable actor '" + this.getCallableName() + "' not found, ignoring.");
            }
        } else {
            if (!(this.m_CallableActor instanceof InputConsumer)) {
                result = "Callable actor '" + this.getCallableName() + "' does not accept input!";
            } else {
                Compatibility comp = new Compatibility();
                if (!comp.isCompatible(new Class[]{Double.class}, ((InputConsumer)((Object)this.m_CallableActor)).accepts())) {
                    result = "Callable actor '" + this.getCallableName() + "' does not accept " + Double.class.getName() + " (" + Utils.classesToString(((InputConsumer)((Object)this.m_CallableActor)).accepts()) + ")!";
                }
            }
            if (result == null) {
                HashSet<String> variables = this.findVariables(this.m_CallableActor);
                this.m_DetectedVariables.addAll(variables);
                if (this.m_DetectedVariables.size() > 0) {
                    this.getVariables().addVariableChangeListener(this);
                }
                if (this.getErrorHandler() != this) {
                    ActorUtils.updateErrorHandler(this.m_CallableActor, this.getErrorHandler(), this.isLoggingEnabled());
                }
            }
        }
        return result;
    }

    @Override
    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("callableName")) == null) {
            result = this.setUpCallableActor();
        }
        return result;
    }

    protected String executeCallableActor(double msec) {
        TimingContainer cont = new TimingContainer(msec, this.m_Prefix, this.getFullName());
        ((InputConsumer)((Object)this.m_CallableActor)).input(new Token(cont));
        String result = this.m_CallableActor.execute();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_TimingEnabled && this.m_StopWatch == null) {
            this.m_StopWatch = new StopWatch();
        }
        if (this.m_TimingEnabled) {
            this.m_StopWatch.reset();
            this.m_StopWatch.start();
        }
        result = super.doExecute();
        if (this.m_TimingEnabled) {
            this.m_StopWatch.stop();
        }
        if (!this.m_Configured) {
            result = this.setUpCallableActor();
        }
        if (result == null && this.m_TimingEnabled && this.m_CallableActor != null && !this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
            AbstractActor abstractActor = this.m_CallableActor;
            synchronized (abstractActor) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing callable actor - start: " + this.m_CallableActor);
                }
                result = this.executeCallableActor(this.m_StopWatch.getTime());
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing callable actor - end: " + result);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isFinished() {
        if (this.m_CallableActor == null) {
            return true;
        }
        return this.m_CallableActor.isFinished();
    }

    @Override
    public void stopExecution() {
        try {
            if (this.m_CallableActor != null) {
                this.m_CallableActor.notifyAll();
                this.m_CallableActor.stopExecution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapUp() {
        if (this.m_CallableActor != null) {
            AbstractActor abstractActor = this.m_CallableActor;
            synchronized (abstractActor) {
                this.m_CallableActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_CallableActor != null) {
            this.m_CallableActor.cleanUp();
            this.m_CallableActor = null;
        }
    }
}

