/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.plotprocessor;

import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.plotprocessor.AbstractPlotProcessor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class SavitzkyGolay
extends AbstractPlotProcessor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5171916489269022308L;
    protected int m_PolynomialOrder;
    protected int m_DerivativeOrder;
    protected int m_NumPointsLeft;
    protected int m_NumPointsRight;
    protected double[] m_Coefficients;
    protected List<Point2D> m_Data;

    @Override
    public String globalInfo() {
        return "A processor that applies SavitzkyGolay smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Data = new ArrayList<Point2D>();
        this.m_Coefficients = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Data.clear();
        this.m_Coefficients = null;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return adams.data.utils.SavitzkyGolay.getTechnicalInformation();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("polynomial", "polynomialOrder", 2, 2, null);
        this.m_OptionManager.add("derivative", "derivativeOrder", 1, 0, null);
        this.m_OptionManager.add("left", "numPointsLeft", 3, 0, null);
        this.m_OptionManager.add("right", "numPointsRight", 3, 0, null);
    }

    public void resetCoefficients() {
        this.m_Coefficients = null;
    }

    public void setPolynomialOrder(int value) {
        if (value >= 2) {
            this.m_PolynomialOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The polynomial order must be at least 2 (provided: " + value + ")!");
        }
    }

    public int getPolynomialOrder() {
        return this.m_PolynomialOrder;
    }

    public String polynomialOrderTipText() {
        return "The polynomial order to use, must be at least 2.";
    }

    public void setDerivativeOrder(int value) {
        if (value >= 0) {
            this.m_DerivativeOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The order of the derivative must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getDerivativeOrder() {
        return this.m_DerivativeOrder;
    }

    public String derivativeOrderTipText() {
        return "The order of the derivative to use, >= 0.";
    }

    public void setNumPointsLeft(int value) {
        if (value >= 0) {
            this.m_NumPointsLeft = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The number of points to the left must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsLeft() {
        return this.m_NumPointsLeft;
    }

    public String numPointsLeftTipText() {
        return "The number of points left of a data point, >= 0.";
    }

    public void setNumPointsRight(int value) {
        if (value >= 0) {
            this.m_NumPointsRight = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The number of points to the right must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsRight() {
        return this.m_NumPointsRight;
    }

    public String numPointsRightTipText() {
        return "The number of points right of a data point, >= 0.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "polynomialOrder", this.m_PolynomialOrder, ", PO: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "derivativeOrder", this.m_DerivativeOrder, ", DO: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numPointsLeft", this.m_NumPointsLeft, ", L: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numPointsRight", this.m_NumPointsLeft, ", R: ");
        return result;
    }

    @Override
    protected List<SequencePlotterContainer> doProcess(SequencePlotterContainer cont) {
        ArrayList<SequencePlotterContainer> result = null;
        Comparable x = (Comparable)cont.getValue("X");
        Comparable y = (Comparable)cont.getValue("Y");
        if (x instanceof Number && y instanceof Number) {
            Point2D.Double point = new Point2D.Double(((Number)((Object)x)).doubleValue(), ((Number)((Object)y)).doubleValue());
            this.m_Data.add(point);
            while (this.m_Data.size() > this.m_NumPointsLeft + this.m_NumPointsRight + 1) {
                this.m_Data.remove(0);
            }
            if (this.m_Data.size() == this.m_NumPointsLeft + this.m_NumPointsRight + 1) {
                if (this.m_Coefficients == null) {
                    this.m_Coefficients = adams.data.utils.SavitzkyGolay.determineCoefficients(this.m_NumPointsLeft, this.m_NumPointsRight, this.m_PolynomialOrder, this.m_DerivativeOrder, this.isLoggingEnabled());
                }
                result = new ArrayList<SequencePlotterContainer>();
                int width = this.m_NumPointsLeft + this.m_NumPointsRight + 1;
                for (int i = 0; i <= this.m_Data.size() - width; ++i) {
                    double value = 0.0;
                    for (int n = 0; n < width; ++n) {
                        value += this.m_Coefficients[n] * this.m_Data.get(i + n).getY();
                    }
                    result.add(new SequencePlotterContainer(this.getPlotName(cont), Double.valueOf(this.m_Data.get(i + this.m_NumPointsLeft).getX()), Double.valueOf(value), this.getPlotType()));
                }
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Data.clear();
    }
}

