/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ClassLister;
import adams.core.ClassLocator;
import adams.core.Properties;
import adams.core.ShallowCopySupporter;
import adams.core.SizeOf;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.VariablesHandler;
import adams.core.base.BaseAnnotation;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.db.LogEntry;
import adams.db.MutableLogEntryHandler;
import adams.event.VariableChangeEvent;
import adams.flow.container.AbstractContainer;
import adams.flow.control.Flow;
import adams.flow.control.ScopeHandler;
import adams.flow.control.StorageHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorVariablesFinder;
import adams.flow.core.ErrorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.InteractiveActor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.OutputProducer;
import adams.flow.execution.DefaultFlowExecutionListeningSupporter;
import adams.flow.execution.FlowExecutionListeningSupporter;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class AbstractActor
extends AbstractOptionHandler
implements Actor,
ShallowCopySupporter<AbstractActor> {
    private static final long serialVersionUID = 6658513163932343273L;
    protected AbstractActor m_Self;
    protected String m_Name;
    protected String m_FullName;
    protected String m_LoggingPrefix;
    protected AbstractActor m_Parent;
    protected boolean m_Executed;
    protected boolean m_Executing;
    protected boolean m_Stopped;
    protected String m_StopMessage;
    protected BaseAnnotation m_Annotations;
    protected boolean m_Skip;
    protected boolean m_StopFlowOnError;
    protected boolean m_Silent;
    protected HashSet<String> m_DetectedVariables;
    protected HashSet<String> m_DetectedObjectVariables;
    protected HashSet<String> m_VariablesUpdated;
    protected Hashtable<String, Object> m_BackupState;
    protected AbstractActor m_Root;
    protected StorageHandler m_StorageHandler;
    protected ScopeHandler m_ScopeHandler;
    protected ErrorHandler m_ErrorHandler;
    protected FlowExecutionListeningSupporter m_ExecutionListeningSupporter;

    @Override
    public String getAdditionalInformation() {
        int i;
        Class[] cls;
        StringBuilder result = new StringBuilder();
        result.append("Flow input/output:");
        boolean singleton = true;
        ArrayList<Class> containers = new ArrayList<Class>();
        if (this instanceof InputConsumer) {
            singleton = false;
            result.append("\n- input: ");
            cls = ((InputConsumer)((Object)this)).accepts();
            result.append(Utils.classesToString(cls));
            for (i = 0; i < cls.length; ++i) {
                if (!ClassLocator.isSubclass(AbstractContainer.class, cls[i]) || cls[i].equals(AbstractContainer.class)) continue;
                containers.add(cls[i]);
            }
        }
        if (this instanceof OutputProducer) {
            singleton = false;
            result.append("\n- output: ");
            cls = ((OutputProducer)((Object)this)).generates();
            for (i = 0; i < cls.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(Utils.classToString(cls[i]));
                if (!ClassLocator.isSubclass(AbstractContainer.class, cls[i]) || cls[i].equals(AbstractContainer.class)) continue;
                containers.add(cls[i]);
            }
        }
        if (singleton) {
            result.append("\n-singleton-");
        }
        if (containers.size() > 0) {
            result.append("\nContainer information:");
            for (i = 0; i < containers.size(); ++i) {
                result.append("\n- " + ((Class)containers.get(i)).getName() + ": ");
                try {
                    AbstractContainer cont = (AbstractContainer)((Class)containers.get(i)).newInstance();
                    boolean first = true;
                    Iterator<String> enm = cont.names();
                    while (enm.hasNext()) {
                        if (!first) {
                            result.append(", ");
                        }
                        result.append(enm.next());
                        first = false;
                    }
                    continue;
                }
                catch (Exception e) {
                    result.append("[error]");
                    this.getLogger().log(Level.SEVERE, "Failed to instantiate container '" + ((Class)containers.get(i)).getName() + "':", e);
                }
            }
        }
        if (this instanceof ActorHandler) {
            ActorHandlerInfo info = ((ActorHandler)((Object)this)).getActorHandlerInfo();
            result.append("\nActor handler information:");
            if (info.getActorExecution() != ActorExecution.UNDEFINED) {
                result.append("\n- Actor execution: " + (Object)((Object)info.getActorExecution()));
            }
            result.append("\n- Standalones allowed: " + info.canContainStandalones());
            result.append("\n- Source allowed: " + info.canContainSource());
            result.append("\n- Forwards input: " + info.getForwardsInput());
            if (info.hasRestrictions()) {
                result.append("\n- Restrictions: ");
                for (i = 0; i < info.getRestrictions().length; ++i) {
                    if (i > 0) {
                        result.append(", ");
                    }
                    result.append(info.getRestrictions()[i].getName());
                }
            }
        }
        return result.toString();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Parent = null;
        this.m_Root = null;
        this.m_FullName = null;
        this.m_Name = "";
        this.m_DetectedVariables = null;
        this.m_DetectedObjectVariables = null;
        this.m_VariablesUpdated = new HashSet();
        this.m_Self = this;
        this.m_LoggingPrefix = "";
        this.setErrorHandler(this);
        this.updatePrefix();
    }

    @Override
    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger(this.m_LoggingPrefix);
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    protected void updatePrefix() {
        this.m_LoggingPrefix = this.getFullName();
        this.m_Logger = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", this.getDefaultName());
        this.m_OptionManager.add("annotation", "annotations", new BaseAnnotation(""));
        this.m_OptionManager.add("skip", "skip", false);
        this.m_OptionManager.add("stop-flow-on-error", "stopFlowOnError", false);
        this.m_OptionManager.add("silent", "silent", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.pruneBackup();
    }

    @Override
    public String getDefaultName() {
        return this.getClass().getName().replaceAll(".*\\.", "");
    }

    @Override
    public boolean isHeadless() {
        if (this.getRoot() != null) {
            return this.getRoot().isHeadless();
        }
        return GraphicsEnvironment.isHeadless();
    }

    @Override
    public void setName(String value) {
        this.m_Name = value;
        this.reset();
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The name of the actor.";
    }

    @Override
    public void setAnnotations(BaseAnnotation value) {
        this.m_Annotations = value;
        this.reset();
    }

    @Override
    public BaseAnnotation getAnnotations() {
        return this.m_Annotations;
    }

    public String annotationsTipText() {
        return "The annotations to attach to this actor.";
    }

    @Override
    public void setSkip(boolean value) {
        this.m_Skip = value;
        this.reset();
    }

    @Override
    public boolean getSkip() {
        return this.m_Skip;
    }

    public String skipTipText() {
        return "If set to true, transformation is skipped and the input token is just forwarded as it is.";
    }

    @Override
    public void setStopFlowOnError(boolean value) {
        this.m_StopFlowOnError = value;
        this.reset();
    }

    @Override
    public boolean getStopFlowOnError() {
        return this.m_StopFlowOnError;
    }

    public String stopFlowOnErrorTipText() {
        return "If set to true, the flow gets stopped in case this actor encounters an error; useful for critical actors.";
    }

    @Override
    public void setSilent(boolean value) {
        this.m_Silent = value;
        this.reset();
    }

    @Override
    public boolean getSilent() {
        return this.m_Silent;
    }

    public String silentTipText() {
        return "If enabled, then no errors are output in the console.";
    }

    @Override
    public String handleError(AbstractActor source, String type, String msg) {
        block15: {
            block14: {
                Flow flow = null;
                MutableLogEntryHandler handler = null;
                LogEntry entry = null;
                Properties props = null;
                if (source.getRoot() instanceof Flow) {
                    flow = (Flow)source.getRoot();
                    if (flow.getLogErrors()) {
                        entry = new LogEntry();
                    }
                } else if (source.getRoot() instanceof MutableLogEntryHandler) {
                    entry = new LogEntry();
                }
                if (entry != null) {
                    handler = (MutableLogEntryHandler)((Object)source.getRoot());
                    props = new Properties();
                    props.setProperty("Message", msg);
                    entry.setGeneration(new Date());
                    entry.setSource(this.getFullName());
                    entry.setType(type);
                    entry.setStatus("New");
                    entry.setMessage(props);
                    handler.addLogEntry(entry);
                }
                msg = source.getFullName() + ": " + msg;
                if (flow == null) break block14;
                switch (flow.getErrorHandling()) {
                    case ACTORS_ALWAYS_STOP_ON_ERROR: {
                        flow.stopExecution(msg);
                        msg = null;
                        break block15;
                    }
                    case ACTORS_DECIDE_TO_STOP_ON_ERROR: {
                        boolean stop = false;
                        if (this.getStopFlowOnError()) {
                            stop = true;
                        }
                        if (source instanceof InteractiveActor && ((InteractiveActor)((Object)source)).getStopFlowIfCanceled()) {
                            stop = true;
                        }
                        if (source instanceof OptionalPasswordPrompt) {
                            stop = true;
                        }
                        if (stop) {
                            flow.stopExecution(msg);
                        }
                        msg = null;
                        break block15;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled error handling: " + (Object)((Object)flow.getErrorHandling()));
                    }
                }
            }
            if (this.getStopFlowOnError()) {
                source.getRoot().stopExecution(msg);
                msg = null;
            }
        }
        return msg;
    }

    protected String handleException(String msg, Throwable t) {
        return Utils.handleException(this, msg, t, this.m_Silent);
    }

    @Override
    public void setParent(AbstractActor value) {
        if (value != this.m_Parent) {
            this.m_Parent = value;
            this.m_FullName = null;
            this.m_Root = null;
            this.m_StorageHandler = null;
            this.m_ScopeHandler = null;
            this.m_ExecutionListeningSupporter = null;
            this.updatePrefix();
        }
    }

    @Override
    public AbstractActor getParent() {
        return this.m_Parent;
    }

    @Override
    public Component getParentComponent() {
        if (this.getRoot() != null) {
            return this.getRoot().getParentComponent();
        }
        return null;
    }

    @Override
    public int index() {
        int result = -1;
        if (this.m_Parent != null && this.m_Parent instanceof ActorHandler) {
            result = ((ActorHandler)((Object)this.m_Parent)).indexOf(this.getName());
        }
        return result;
    }

    @Override
    public synchronized AbstractActor getRoot() {
        if (this.m_Root == null) {
            this.m_Root = this.getParent() == null ? this : this.getParent().getRoot();
        }
        return this.m_Root;
    }

    protected void updateDetectedVariables() {
        this.getOptionManager().registerVariables();
        this.m_DetectedVariables = this.findVariables();
        this.m_DetectedObjectVariables = new HashSet();
        for (String var : this.m_DetectedVariables) {
            if (!this.getVariables().isObject(var)) continue;
            this.m_DetectedObjectVariables.add(var);
        }
        this.m_DetectedVariables.removeAll(this.m_DetectedObjectVariables);
        if (this.m_DetectedVariables.size() > 0) {
            this.getVariables().addVariableChangeListener(this);
        }
    }

    protected void forceVariables(Variables value) {
        this.getOptionManager().getVariables().removeVariableChangeListener(this);
        this.getOptionManager().deregisterVariables();
        if (this.getOptionManager().getVariables() != value) {
            this.getOptionManager().getVariables().cleanUp();
        }
        this.getOptionManager().setVariables(value);
        this.getOptionManager().getVariables().addVariableChangeListener(this);
        this.getOptionManager().updateVariablesInstance(value);
        this.updateDetectedVariables();
    }

    @Override
    public synchronized void setVariables(Variables value) {
        if (this.getVariables() != value) {
            this.forceVariables(value);
        }
    }

    @Override
    public Variables getVariables() {
        if (this instanceof VariablesHandler) {
            return ((VariablesHandler)((Object)this)).getLocalVariables();
        }
        return this.getOptionManager().getVariables();
    }

    @Override
    public StorageHandler getStorageHandler() {
        if (this.m_StorageHandler == null) {
            if (this instanceof StorageHandler) {
                this.m_StorageHandler = (StorageHandler)((Object)this);
            } else if (this.getParent() != null) {
                this.m_StorageHandler = this.getParent().getStorageHandler();
            }
        }
        return this.m_StorageHandler;
    }

    @Override
    public ScopeHandler getScopeHandler() {
        if (this.m_ScopeHandler == null) {
            if (this instanceof ScopeHandler) {
                this.m_ScopeHandler = (ScopeHandler)((Object)this);
            } else if (this.getParent() != null) {
                this.m_ScopeHandler = this.getParent().getScopeHandler();
            }
        }
        return this.m_ScopeHandler;
    }

    @Override
    public FlowExecutionListeningSupporter getFlowExecutionListeningSupporter() {
        if (this.m_ExecutionListeningSupporter == null) {
            if (this instanceof FlowExecutionListeningSupporter) {
                this.m_ExecutionListeningSupporter = (FlowExecutionListeningSupporter)((Object)this);
            } else if (this.getParent() != null) {
                this.m_ExecutionListeningSupporter = this.getParent().getFlowExecutionListeningSupporter();
            }
            if (this.m_ExecutionListeningSupporter == null && this == this.getRoot()) {
                this.m_ExecutionListeningSupporter = new DefaultFlowExecutionListeningSupporter();
            }
        }
        return this.m_ExecutionListeningSupporter;
    }

    @Override
    public String getFullName() {
        if (this.m_FullName == null) {
            StringBuilder result = new StringBuilder(this.getName().replace(".", "\\."));
            AbstractActor parent = this.getParent();
            if (parent != null) {
                result.insert(0, parent.getFullName() + ".");
            }
            this.m_FullName = result.toString();
        }
        return this.m_FullName;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public boolean hasErrorHandler() {
        return this.m_ErrorHandler != null;
    }

    @Override
    public void setErrorHandler(ErrorHandler value) {
        this.m_ErrorHandler = value;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_ErrorHandler;
    }

    @Override
    public boolean canInspectOptions(Class cls) {
        return true;
    }

    @Override
    public HashSet<String> findVariables() {
        return this.findVariables(this);
    }

    protected HashSet<String> findVariables(AbstractActor actor) {
        this.getLogger().finest("Locating variables in " + actor.getFullName() + "...");
        ActorVariablesFinder finder = new ActorVariablesFinder();
        finder.setInspection(actor);
        actor.getOptionManager().traverse(finder);
        Object result = finder.getResult();
        this.getLogger().finest("Found variables in " + actor.getFullName() + " (" + ((HashSet)result).size() + "): " + result);
        return result;
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        if (this.m_DetectedVariables == null || this.m_DetectedVariables.size() == 0) {
            return;
        }
        if (this.m_VariablesUpdated.contains(e.getName())) {
            return;
        }
        if (this.m_DetectedVariables.contains(e.getName()) && e.getType() != VariableChangeEvent.Type.REMOVED) {
            this.m_VariablesUpdated.add(e.getName());
            this.getLogger().info("Changes in variable '" + e.getName() + "'");
        }
    }

    @Override
    public HashSet<String> getDetectedVariables() {
        HashSet<String> result = this.m_DetectedVariables != null ? this.m_DetectedVariables : new HashSet();
        return result;
    }

    @Override
    public String setUp() {
        this.reset();
        this.m_FullName = null;
        this.updatePrefix();
        this.updateDetectedVariables();
        this.m_Stopped = false;
        this.m_StopMessage = null;
        this.m_Executed = false;
        String result = this.performSetUpChecks(true);
        return result;
    }

    protected boolean isBackedUp(String key) {
        if (this.m_BackupState == null) {
            return false;
        }
        return this.m_BackupState.containsKey(key);
    }

    protected void pruneBackup(String key) {
        if (this.m_BackupState == null) {
            return;
        }
        if (!this.m_BackupState.containsKey(key)) {
            return;
        }
        this.m_BackupState.remove(key);
    }

    protected void pruneBackup() {
    }

    protected Hashtable<String, Object> backupState() {
        return new Hashtable<String, Object>();
    }

    protected void restoreState(Hashtable<String, Object> state) {
    }

    protected String updateVariables() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Attempting updating variables (" + this.getOptionManager().getVariables().hashCode() + "): " + this.m_VariablesUpdated + "/" + this.m_DetectedObjectVariables);
        }
        this.m_BackupState = this.backupState();
        this.getOptionManager().updateVariableValues();
        String result = this.setUp();
        if (result == null) {
            this.restoreState(this.m_BackupState);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Finished updating variables " + this.m_VariablesUpdated + "/" + this.m_DetectedObjectVariables + ": " + (result == null ? "successful" : result));
        }
        this.m_BackupState = null;
        this.m_VariablesUpdated.clear();
        return result;
    }

    protected boolean canPerformSetUpCheck(boolean fromSetUp, String property) {
        boolean result = true;
        String variable = this.getOptionManager().getVariableForProperty(property);
        if (fromSetUp) {
            if (variable != null) {
                result = false;
            }
        } else if (variable == null) {
            result = false;
        }
        return result;
    }

    protected String performSetUpChecks(boolean fromSetUp) {
        return null;
    }

    protected String preExecute() {
        String result = null;
        if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINEST)) {
            this.getLogger().finest("Size before execute: " + this.sizeOf());
        }
        if (this.m_VariablesUpdated.size() > 0 || this.m_DetectedVariables != null && this.m_DetectedObjectVariables.size() > 0) {
            this.updateVariables();
            result = this.performSetUpChecks(false);
        }
        return result;
    }

    protected abstract String doExecute();

    protected String postExecute() {
        if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINEST)) {
            this.getLogger().finest("Size after execute: " + this.sizeOf());
        }
        this.m_Executed = !this.isStopped();
        return null;
    }

    @Override
    public String execute() {
        String result = null;
        if (!this.m_Skip) {
            this.m_Executing = true;
            if (!this.isStopped()) {
                result = this.preExecute();
            }
        }
        if (!this.m_Skip) {
            if (result == null && !this.isStopped()) {
                result = this.doExecute();
            }
            if (result == null && !this.isStopped()) {
                result = this.postExecute();
            }
            this.m_Executing = false;
        }
        return result;
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    protected void finalUpdateVariables() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Attempting final update of variables (" + this.getOptionManager().getVariables().hashCode() + "): " + this.m_VariablesUpdated + "/" + this.m_DetectedObjectVariables);
        }
        this.getOptionManager().updateVariableValues();
        this.m_VariablesUpdated.clear();
    }

    @Override
    public void wrapUp() {
        if (this.m_VariablesUpdated.size() > 0 || this.m_DetectedVariables != null && this.m_DetectedObjectVariables.size() > 0) {
            this.finalUpdateVariables();
        }
        this.getOptionManager().deregisterVariables();
        this.m_ErrorHandler = null;
        if (this.m_DetectedVariables != null) {
            this.m_DetectedVariables.clear();
            this.m_DetectedVariables = null;
        }
        if (this.m_DetectedObjectVariables != null) {
            this.m_DetectedObjectVariables.clear();
            this.m_DetectedObjectVariables = null;
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
    }

    @Override
    public void stopExecution(String msg) {
        this.m_StopMessage = msg;
        this.stopExecution();
    }

    @Override
    public boolean isStopped() {
        return this.m_Stopped;
    }

    @Override
    public boolean hasStopMessage() {
        return this.m_StopMessage != null;
    }

    @Override
    public String getStopMessage() {
        return this.m_StopMessage;
    }

    @Override
    public boolean isExecuted() {
        return this.m_Executed;
    }

    public boolean isExecuting() {
        return this.m_Executing;
    }

    @Override
    public AbstractActor getPreviousSibling() {
        int index;
        AbstractActor result = null;
        if (this.getParent() instanceof ActorHandler && (index = ((ActorHandler)((Object)this.getParent())).indexOf(this.getName())) > 0) {
            result = ((ActorHandler)((Object)this.getParent())).get(index - 1);
        }
        return result;
    }

    @Override
    public AbstractActor getNextSibling() {
        int index;
        AbstractActor result = null;
        if (this.getParent() instanceof ActorHandler && (index = ((ActorHandler)((Object)this.getParent())).indexOf(this.getName())) < ((ActorHandler)((Object)this.getParent())).size() - 1) {
            result = ((ActorHandler)((Object)this.getParent())).get(index + 1);
        }
        return result;
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    @Override
    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractActor shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractActor shallowCopy(boolean expand) {
        return (AbstractActor)OptionUtils.shallowCopy(this, expand);
    }

    @Override
    public synchronized int sizeOf() {
        AbstractActor parent = this.m_Parent;
        this.m_Parent = null;
        int result = SizeOf.sizeOf(this);
        this.m_Parent = parent;
        return result;
    }

    public static String[] getFlowActors() {
        return ClassLister.getSingleton().getClassnames(AbstractActor.class);
    }

    public static AbstractActor forName(String classname, String[] options) {
        AbstractActor result;
        try {
            result = (AbstractActor)OptionUtils.forName(AbstractActor.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractActor forCommandLine(String cmdline) {
        return (AbstractActor)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

