/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import java.io.Serializable;
import java.util.ArrayList;

public class ActorPath
implements Comparable<ActorPath>,
Serializable {
    private static final long serialVersionUID = -5734626103557090578L;
    protected String[] m_Parts;
    protected String m_FullPath;

    public ActorPath() {
        this("");
    }

    public ActorPath(String path) {
        this.m_FullPath = null;
        if (path == null || path.length() == 0) {
            this.m_Parts = new String[0];
        } else {
            if ((path = path.replace("\\.", "\t")).startsWith("[") && path.endsWith("]")) {
                path = path.substring(1, path.length() - 1);
            }
            if (path.matches(".*\\.[\\w]*Director$")) {
                path = path.replaceAll("\\.[\\w]*Director$", "");
            }
            if (path.indexOf(47) > -1) {
                path = path.replaceAll("\\/[0-9]+-(OUT|ERR|DEBUG).*", "");
            }
            path = path.replaceAll("\\s*$", "");
            this.m_Parts = path.split("\\.");
            for (int i = 0; i < this.m_Parts.length; ++i) {
                this.m_Parts[i] = this.m_Parts[i].replace("\t", ".");
            }
        }
    }

    public ActorPath(String[] path) {
        this.m_Parts = (String[])path.clone();
        this.m_FullPath = null;
    }

    public String[] getPath() {
        return (String[])this.m_Parts.clone();
    }

    public int getPathCount() {
        return this.m_Parts.length;
    }

    public String getPathComponent(int element) {
        return this.m_Parts[element];
    }

    public ActorPath getParentPath() {
        String[] parts;
        if (this.m_Parts.length >= 1) {
            parts = new String[this.m_Parts.length - 1];
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = new String(this.m_Parts[i]);
            }
        } else {
            parts = new String[]{};
        }
        return new ActorPath(parts);
    }

    public ActorPath getChildPath() {
        String[] parts;
        if (this.m_Parts.length >= 1) {
            parts = new String[this.m_Parts.length - 1];
            for (int i = 1; i < this.m_Parts.length; ++i) {
                parts[i - 1] = new String(this.m_Parts[i]);
            }
        } else {
            parts = new String[]{};
        }
        return new ActorPath(parts);
    }

    public String getLastPathComponent() {
        if (this.m_Parts.length > 0) {
            return new String(this.m_Parts[this.m_Parts.length - 1]);
        }
        return null;
    }

    public String getFirstPathComponent() {
        if (this.m_Parts.length > 0) {
            return new String(this.m_Parts[0]);
        }
        return null;
    }

    public boolean isDescendant(ActorPath actorPath) {
        boolean result;
        boolean bl = result = actorPath.getPathCount() >= this.getPathCount();
        if (result) {
            for (int i = 0; i < this.getPathCount(); ++i) {
                if (this.getPathComponent(i).equals(actorPath.getPathComponent(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public ActorPath getCommonAncestor(ActorPath actorPath) {
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < this.getPathCount() && i < actorPath.getPathCount() && this.getPathComponent(i).equals(actorPath.getPathComponent(i)); ++i) {
            parts.add(new String(this.getPathComponent(i)));
        }
        return new ActorPath(parts.toArray(new String[parts.size()]));
    }

    @Override
    public int compareTo(ActorPath o) {
        if (this.getPathCount() == 0 || o.getPathCount() == 0) {
            return new Integer(this.getPathCount()).compareTo(o.getPathCount());
        }
        int result = 0;
        for (int i = 0; i < this.getPathCount() && i < o.getPathCount(); ++i) {
            result = this.getPathComponent(i).compareTo(o.getPathComponent(i));
            if (result == 0 && (i == this.getPathCount() - 1 || i == o.getPathCount() - 1)) {
                result = new Integer(this.getPathCount()).compareTo(o.getPathCount());
            }
            if (result != 0) break;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ActorPath) {
            return this.compareTo((ActorPath)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.m_Parts.hashCode();
    }

    public String toString() {
        if (this.m_FullPath == null) {
            StringBuilder path = new StringBuilder();
            for (String part : this.m_Parts) {
                if (path.length() > 0) {
                    path.append(".");
                }
                path.append(part.replace(".", "\\."));
            }
            this.m_FullPath = path.toString();
        }
        return this.m_FullPath;
    }
}

