/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.Stoppable;
import adams.core.Variables;
import adams.core.base.BaseString;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.core.Actor;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.execution.AbstractBreakpoint;
import adams.flow.execution.AbstractGraphicalFlowExecutionListener;
import adams.flow.execution.ExecutionStage;
import adams.flow.execution.debug.ControlPanel;
import adams.flow.execution.debug.View;
import adams.gui.core.BasePanel;
import adams.gui.tools.ExpressionWatchPanel;
import java.awt.Dimension;

public class Debug
extends AbstractGraphicalFlowExecutionListener
implements Stoppable {
    private static final long serialVersionUID = -7287036923779341439L;
    protected int m_Width;
    protected int m_Height;
    protected AbstractBreakpoint[] m_Breakpoints;
    protected View[] m_Views;
    protected BaseString[] m_Watches;
    protected ExpressionWatchPanel.ExpressionType[] m_WatchTypes;
    protected boolean m_StepByStep;
    protected transient ControlPanel m_DebugPanel;
    protected boolean m_Blocked;
    protected transient Actor m_Current;
    protected boolean m_ExecuteNext;
    protected boolean m_Stopped;

    @Override
    public String globalInfo() {
        return "Allows the user to define breakpoints that suspend the execution of the flow, allowing the inspection of the current flow state.\nTokens can only inspected during 'preInput', 'preExecute' and 'postOutput' of Breakpoint control actors. Step-wise debugging stops in 'preExecute', which should be able to access the current token in case of input consumers (ie transformers and sinks).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", this.getDefaultWidth(), -1, null);
        this.m_OptionManager.add("height", "height", this.getDefaultHeight(), -1, null);
        this.m_OptionManager.add("breakpoint", "breakpoints", new AbstractBreakpoint[0]);
        this.m_OptionManager.add("watch", "watches", new BaseString[0]);
        this.m_OptionManager.add("watch-type", "watchTypes", new ExpressionWatchPanel.ExpressionType[0]);
        this.m_OptionManager.add("view", "views", new View[0]);
        this.m_OptionManager.add("step-by-step", "stepByStep", false);
    }

    protected int getDefaultWidth() {
        return 900;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    public void setBreakpoints(AbstractBreakpoint[] value) {
        this.m_Breakpoints = value;
        this.reset();
    }

    public AbstractBreakpoint[] getBreakpoints() {
        return this.m_Breakpoints;
    }

    public String breakpointsTipText() {
        return "The breakpoints to use for suspending the flow execution.";
    }

    public void setWatches(BaseString[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!Variables.isPlaceholder(value[i].getValue())) continue;
            value[i] = new BaseString("(" + value[i].getValue() + ")");
        }
        this.m_Watches = value;
        this.reset();
    }

    public BaseString[] getWatches() {
        return this.m_Watches;
    }

    public String watchesTipText() {
        return "The expression to display initially in the watch dialog; the type of the watch needs to be specified as well.";
    }

    public void setWatchTypes(ExpressionWatchPanel.ExpressionType[] value) {
        this.m_WatchTypes = value;
        this.reset();
    }

    public ExpressionWatchPanel.ExpressionType[] getWatchTypes() {
        return this.m_WatchTypes;
    }

    public String watchTypesTipText() {
        return "The types of the watch expressions; determines how the expressions get evaluated and displayed.";
    }

    public void setViews(View[] value) {
        this.m_Views = value;
        this.reset();
    }

    public View[] getViews() {
        return this.m_Views;
    }

    public String viewsTipText() {
        return "The views to display automatically when the breakpoint is reached.";
    }

    public void setStepByStep(boolean value) {
        this.m_StepByStep = value;
        this.reset();
    }

    public boolean getStepByStep() {
        return this.m_StepByStep;
    }

    public String stepByStepTipText() {
        return "Whether to start in step-by-step mode or wait for first breakpoint.";
    }

    public void setStepMode(boolean value) {
        if (this.m_DebugPanel != null) {
            this.m_DebugPanel.setStepModeEnabled(value);
        }
    }

    public boolean isStepMode() {
        if (this.m_DebugPanel != null) {
            return this.m_DebugPanel.isStepModeEnabled();
        }
        return false;
    }

    @Override
    public String getListenerTitle() {
        return "Debug";
    }

    @Override
    public void startListening() {
        super.startListening();
        this.m_Stopped = false;
    }

    @Override
    public BasePanel newListenerPanel() {
        this.m_DebugPanel = new ControlPanel();
        this.m_DebugPanel.setOwner(this);
        for (int i = 0; i < this.m_Watches.length; ++i) {
            this.m_DebugPanel.addWatch(this.m_Watches[i].getValue(), this.m_WatchTypes[i]);
        }
        this.setStepMode(this.m_StepByStep);
        return this.m_DebugPanel;
    }

    @Override
    public Dimension getDefaultFrameSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public boolean getDisposeOnFinish() {
        return true;
    }

    @Override
    protected void updateGUI() {
        if (this.m_DebugPanel != null) {
            this.m_DebugPanel.closeParent();
        }
    }

    public boolean isBlocked() {
        return this.m_Blocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockExecution() {
        this.m_Blocked = true;
        this.m_DebugPanel.update();
        while (this.m_Blocked && !this.m_Stopped && !this.m_DebugPanel.getCurrentActor().isStopped()) {
            try {
                Debug debug = this;
                synchronized (debug) {
                    this.wait(50L);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void unblockExecution() {
        this.m_Blocked = false;
    }

    protected void triggered(AbstractBreakpoint point, Actor actor, ExecutionStage stage) {
        if (this.m_Stopped || this.getOwner() != null && this.getOwner().isStopped()) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info(point.getClass().getName() + "/" + stage + ": " + actor.getFullName());
        }
        boolean blocked = point == null && this.isStepMode() || point != null;
        this.m_DebugPanel.setCurrentStage(stage);
        this.m_DebugPanel.setCurrentActor(actor);
        this.m_DebugPanel.setCurrentToken(null);
        this.m_DebugPanel.setCurrentBreakpoint(point);
        if (point instanceof BooleanConditionSupporter) {
            this.m_DebugPanel.setCurrentCondition(((BooleanConditionSupporter)((Object)point)).getCondition());
        } else {
            this.m_DebugPanel.setCurrentCondition(null);
        }
        this.m_DebugPanel.showFrame();
        this.m_DebugPanel.breakpointReached(blocked);
        if (blocked) {
            this.blockExecution();
        }
    }

    protected void triggered(AbstractBreakpoint point, Actor actor, ExecutionStage stage, Token token) {
        if (this.m_Stopped || this.getOwner() != null && this.getOwner().isStopped()) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info(point.getClass().getName() + "/" + stage + ": " + actor.getFullName() + "\n\t" + token);
        }
        boolean blocked = point == null && this.isStepMode() || point != null;
        this.m_DebugPanel.setCurrentStage(stage);
        this.m_DebugPanel.setCurrentActor(actor);
        this.m_DebugPanel.setCurrentToken(token);
        this.m_DebugPanel.setCurrentBreakpoint(point);
        if (point instanceof BooleanConditionSupporter) {
            this.m_DebugPanel.setCurrentCondition(((BooleanConditionSupporter)((Object)point)).getCondition());
        } else {
            this.m_DebugPanel.setCurrentCondition(null);
        }
        this.m_DebugPanel.showFrame();
        this.m_DebugPanel.breakpointReached(blocked);
        if (blocked) {
            this.blockExecution();
        }
    }

    @Override
    public void preInput(Actor actor, Token token) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPreInput(actor, token)) continue;
            this.triggered(point, actor, ExecutionStage.PRE_INPUT, token);
            break;
        }
    }

    @Override
    public void postInput(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPostInput(actor)) continue;
            this.triggered(point, actor, ExecutionStage.POST_INPUT);
            break;
        }
    }

    @Override
    public void preExecute(Actor actor) {
        Token token = null;
        if (actor instanceof InputConsumer) {
            token = ((InputConsumer)actor).currentInput();
        }
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPreExecute(actor)) continue;
            if (token == null) {
                this.triggered(point, actor, ExecutionStage.PRE_EXECUTE);
                break;
            }
            this.triggered(point, actor, ExecutionStage.PRE_EXECUTE, token);
            break;
        }
    }

    @Override
    public void postExecute(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPostExecute(actor)) continue;
            this.triggered(point, actor, ExecutionStage.POST_EXECUTE);
            break;
        }
    }

    @Override
    public void preOutput(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPreOutput(actor)) continue;
            this.triggered(point, actor, ExecutionStage.PRE_OUTPUT);
            break;
        }
    }

    @Override
    public void postOutput(Actor actor, Token token) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPostOutput(actor, token)) continue;
            this.triggered(point, actor, ExecutionStage.POST_OUTPUT);
            break;
        }
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
        this.m_Blocked = false;
    }
}

