/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.flow.control.Flow;
import adams.flow.execution.FlowExecutionListeningSupporter;
import adams.flow.execution.GraphicalFlowExecutionListener;
import adams.gui.core.BaseFrame;
import adams.gui.core.GUIHelper;
import adams.gui.flow.FlowTreeHandler;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.FlowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;

public class ListenerUtils {
    public static BaseFrame createFrame(FlowExecutionListeningSupporter supporter) {
        ListenerFrame result = null;
        if (supporter.getFlowExecutionListener() instanceof GraphicalFlowExecutionListener) {
            GraphicalFlowExecutionListener graphical = (GraphicalFlowExecutionListener)supporter.getFlowExecutionListener();
            result = new ListenerFrame();
            result.setListener(graphical);
            result.setTitle(graphical.getListenerTitle());
            result.setDefaultCloseOperation(1);
            result.getContentPane().setLayout(new BorderLayout());
            result.getContentPane().add((Component)graphical.newListenerPanel(), "Center");
            result.setSize(graphical.getDefaultFrameSize());
            GUIHelper.setSizeAndLocation(result, GUIHelper.calcTopPosition(result, -2), GUIHelper.calcLeftPosition(result, -2));
            result.setVisible(true);
        }
        return result;
    }

    public static class ListenerFrame
    extends BaseFrame
    implements FlowTreeHandler {
        private static final long serialVersionUID = 8433088861525467980L;
        protected GraphicalFlowExecutionListener m_Listener;

        public ListenerFrame() {
        }

        public ListenerFrame(String title) {
            super(title);
        }

        public void setListener(GraphicalFlowExecutionListener value) {
            this.m_Listener = value;
        }

        public GraphicalFlowExecutionListener getListener() {
            return this.m_Listener;
        }

        @Override
        public Tree getTree() {
            Flow flow;
            Tree result = null;
            if (this.m_Listener != null && (flow = this.m_Listener.getOwner()).getParentComponent() != null && flow.getParentComponent() instanceof Container) {
                result = FlowHelper.getTree((Container)flow.getParentComponent());
            }
            return result;
        }
    }
}

