/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution.debug;

import adams.core.CleanUpHandler;
import adams.flow.execution.AbstractBreakpoint;
import adams.flow.execution.AnyActorBreakpoint;
import adams.flow.execution.PathBreakpoint;
import adams.flow.execution.debug.BreakpointTableModel;
import adams.flow.execution.debug.ControlPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.flow.FlowTreeHandler;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class BreakpointPanel
extends BasePanel
implements CleanUpHandler,
FlowTreeHandler,
TableModelListener {
    private static final long serialVersionUID = 8469709963860298334L;
    protected ControlPanel m_Owner;
    protected BaseTableWithButtons m_TableBreakpoints;
    protected BreakpointTableModel m_TableModelBreakpoints;
    protected JButton m_ButtonBreakpointsToggle;
    protected JButton m_ButtonBreakpointsAdd;
    protected JButton m_ButtonBreakpointsEdit;
    protected JButton m_ButtonBreakpointsRemove;
    protected JButton m_ButtonBreakpointsRemoveAll;
    protected GenericObjectEditorDialog m_DialogGOE;
    protected boolean m_IgnoreUpdates;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_TableModelBreakpoints = null;
        this.m_DialogGOE = null;
        this.m_IgnoreUpdates = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_TableBreakpoints = new BaseTableWithButtons();
        this.m_TableBreakpoints.setAutoResizeMode(0);
        this.add((Component)this.m_TableBreakpoints, "Center");
        this.m_ButtonBreakpointsToggle = new JButton("Toggle");
        this.m_ButtonBreakpointsToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPanel.this.toggleBreakpoints();
            }
        });
        this.m_TableBreakpoints.addToButtonsPanel(this.m_ButtonBreakpointsToggle);
        this.m_ButtonBreakpointsAdd = new JButton("Add...");
        this.m_ButtonBreakpointsAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPanel.this.addBreakpoint();
            }
        });
        this.m_TableBreakpoints.addToButtonsPanel(this.m_ButtonBreakpointsAdd);
        this.m_ButtonBreakpointsEdit = new JButton("Edit...");
        this.m_ButtonBreakpointsEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPanel.this.editBreakpoint(BreakpointPanel.this.m_TableBreakpoints.getSelectedRow());
            }
        });
        this.m_TableBreakpoints.addToButtonsPanel(this.m_ButtonBreakpointsEdit);
        this.m_TableBreakpoints.addToButtonsPanel(new JLabel(""));
        this.m_ButtonBreakpointsRemove = new JButton("Remove");
        this.m_ButtonBreakpointsRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPanel.this.removeBreakpoints(BreakpointPanel.this.m_TableBreakpoints.getSelectedRows());
            }
        });
        this.m_TableBreakpoints.addToButtonsPanel(this.m_ButtonBreakpointsRemove);
        this.m_ButtonBreakpointsRemoveAll = new JButton("Remove all");
        this.m_ButtonBreakpointsRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPanel.this.removeBreakpoints(null);
            }
        });
        this.m_TableBreakpoints.addToButtonsPanel(this.m_ButtonBreakpointsRemoveAll);
        this.m_TableBreakpoints.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BreakpointPanel.this.m_ButtonBreakpointsToggle.setEnabled(BreakpointPanel.this.m_TableBreakpoints.getSelectedRowCount() > 0);
                BreakpointPanel.this.m_ButtonBreakpointsAdd.setEnabled(true);
                BreakpointPanel.this.m_ButtonBreakpointsRemove.setEnabled(BreakpointPanel.this.m_TableBreakpoints.getSelectedRowCount() > 0);
                BreakpointPanel.this.m_ButtonBreakpointsRemoveAll.setEnabled(BreakpointPanel.this.m_TableBreakpoints.getModel().getRowCount() > 0);
            }
        });
    }

    public void setOwner(ControlPanel value) {
        if (this.m_TableModelBreakpoints == null || this.m_Owner != value) {
            if (this.m_TableModelBreakpoints != null) {
                this.m_TableModelBreakpoints.removeTableModelListener(this);
            }
            this.m_TableModelBreakpoints = new BreakpointTableModel(value);
            this.m_TableBreakpoints.setModel(this.m_TableModelBreakpoints);
            this.m_TableBreakpoints.setOptimalColumnWidth();
            this.m_TableModelBreakpoints.addTableModelListener(this);
        }
        this.m_Owner = value;
        this.refresh();
    }

    public ControlPanel getOwner() {
        return this.m_Owner;
    }

    protected void toggleBreakpoints() {
        for (int index : this.m_TableBreakpoints.getSelectedRows()) {
            AbstractBreakpoint breakpoint;
            breakpoint.setDisabled(!(breakpoint = this.m_TableModelBreakpoints.getBreakpointAt(index)).getDisabled());
        }
        this.m_Owner.queueUpdate();
    }

    protected AbstractBreakpoint getDefaultBreakpoint() {
        PathBreakpoint result = new PathBreakpoint();
        result.setOnPreInput(true);
        return result;
    }

    protected GenericObjectEditorDialog getGOEDialog() {
        if (this.m_DialogGOE == null) {
            this.m_DialogGOE = GenericObjectEditorDialog.createDialog(this);
            this.m_DialogGOE.getGOEEditor().setClassType(AbstractBreakpoint.class);
            this.m_DialogGOE.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogGOE.setCurrent(this.getDefaultBreakpoint());
        }
        return this.m_DialogGOE;
    }

    protected void addBreakpoint() {
        GenericObjectEditorDialog dialog = this.getGOEDialog();
        dialog.setCurrent(this.getDefaultBreakpoint());
        dialog.setTitle("Add breakpoint");
        dialog.pack();
        dialog.setLocationRelativeTo(this.m_Owner);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        this.m_TableModelBreakpoints.addBreakpoint((AbstractBreakpoint)dialog.getCurrent());
        this.m_Owner.queueUpdate();
    }

    protected void editBreakpoint(int row) {
        AbstractBreakpoint breakpoint = this.m_TableModelBreakpoints.getBreakpointAt(row);
        GenericObjectEditorDialog dialog = this.getGOEDialog();
        dialog.setCurrent(breakpoint);
        dialog.setTitle("Edit breakpoint");
        dialog.pack();
        dialog.setLocationRelativeTo(this.m_Owner);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        this.m_TableModelBreakpoints.setBreakpointAt(row, (AbstractBreakpoint)dialog.getCurrent());
        this.m_Owner.queueUpdate();
    }

    protected void removeBreakpoints(int[] indices) {
        if (indices == null) {
            this.m_TableModelBreakpoints.clearBreakpoints();
        } else {
            for (int i = indices.length - 1; i >= 0; --i) {
                this.m_TableModelBreakpoints.removeBreakpointAt(indices[i]);
            }
        }
        this.m_Owner.queueUpdate();
    }

    public void refresh() {
        if (this.m_TableModelBreakpoints != null) {
            this.m_TableModelBreakpoints.refresh();
        }
    }

    @Override
    public void cleanUp() {
        if (this.m_DialogGOE != null) {
            this.m_DialogGOE.dispose();
            this.m_DialogGOE = null;
        }
    }

    @Override
    public Tree getTree() {
        return this.getOwner().getTree();
    }

    public void setStepModeEnabled(boolean enabled) {
        if (this.getOwner() == null || this.getOwner().getOwner() == null) {
            return;
        }
        AnyActorBreakpoint breakpoint = null;
        for (AbstractBreakpoint bp : this.getOwner().getOwner().getBreakpoints()) {
            if (!(bp instanceof AnyActorBreakpoint)) continue;
            breakpoint = (AnyActorBreakpoint)bp;
            break;
        }
        if (!enabled && breakpoint == null) {
            return;
        }
        if (breakpoint == null) {
            breakpoint = new AnyActorBreakpoint();
            breakpoint.setOnPreExecute(true);
            ArrayList<AbstractBreakpoint> breakpoints = new ArrayList<AbstractBreakpoint>(Arrays.asList(this.getOwner().getOwner().getBreakpoints()));
            breakpoints.add(breakpoint);
            this.getOwner().getOwner().setBreakpoints(breakpoints.toArray(new AbstractBreakpoint[breakpoints.size()]));
        }
        breakpoint.setDisabled(!enabled);
    }

    public boolean isStepModeEnabled() {
        boolean result = false;
        if (this.getOwner() != null && this.getOwner().getOwner() != null) {
            AbstractBreakpoint breakpoint = null;
            for (AbstractBreakpoint bp : this.getOwner().getOwner().getBreakpoints()) {
                if (!(bp instanceof AnyActorBreakpoint)) continue;
                breakpoint = (AnyActorBreakpoint)bp;
                break;
            }
            if (breakpoint != null) {
                result = !breakpoint.getDisabled();
            }
        }
        return result;
    }

    public void setIgnoreUpdates(boolean value) {
        this.m_IgnoreUpdates = value;
    }

    public boolean getIgnoreUpdates() {
        return this.m_IgnoreUpdates;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.m_IgnoreUpdates) {
            return;
        }
        this.m_Owner.queueUpdate();
    }
}

