/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution.debug;

import adams.core.option.OptionUtils;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.execution.AbstractBreakpoint;
import adams.flow.execution.debug.ControlPanel;
import adams.gui.core.AbstractBaseTableModel;
import java.util.ArrayList;
import java.util.Arrays;

public class BreakpointTableModel
extends AbstractBaseTableModel {
    private static final long serialVersionUID = 8719550408646036355L;
    protected ControlPanel m_Owner;

    public BreakpointTableModel(ControlPanel owner) {
        this.m_Owner = owner;
    }

    @Override
    public int getRowCount() {
        return this.m_Owner.getOwner().getBreakpoints().length;
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Current";
            }
            case 1: {
                return "Enabled";
            }
            case 2: {
                return "PreIn";
            }
            case 3: {
                return "PostIn";
            }
            case 4: {
                return "PreEx";
            }
            case 5: {
                return "PostEx";
            }
            case 6: {
                return "PreOut";
            }
            case 7: {
                return "PostOut";
            }
            case 8: {
                return "Type";
            }
            case 9: {
                return "Quickinfo";
            }
            case 10: {
                return "Condition";
            }
        }
        throw new IllegalArgumentException("Illegal column index: " + column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return Boolean.class;
            }
            case 8: 
            case 9: 
            case 10: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Illegal column index: " + columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex >= 1 && columnIndex <= 7;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AbstractBreakpoint breakpoint = this.m_Owner.getOwner().getBreakpoints()[rowIndex];
        switch (columnIndex) {
            case 1: {
                breakpoint.setDisabled((Boolean)aValue == false);
                break;
            }
            case 2: {
                breakpoint.setOnPreInput((Boolean)aValue);
                break;
            }
            case 3: {
                breakpoint.setOnPostInput((Boolean)aValue);
                break;
            }
            case 4: {
                breakpoint.setOnPreExecute((Boolean)aValue);
                break;
            }
            case 5: {
                breakpoint.setOnPostExecute((Boolean)aValue);
                break;
            }
            case 6: {
                breakpoint.setOnPreOutput((Boolean)aValue);
                break;
            }
            case 7: {
                breakpoint.setOnPostOutput((Boolean)aValue);
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AbstractBreakpoint breakpoint = this.m_Owner.getOwner().getBreakpoints()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return this.m_Owner.getCurrentBreakpoint() != null && breakpoint == this.m_Owner.getCurrentBreakpoint();
            }
            case 1: {
                return !breakpoint.getDisabled();
            }
            case 2: {
                return breakpoint.getOnPreInput();
            }
            case 3: {
                return breakpoint.getOnPostInput();
            }
            case 4: {
                return breakpoint.getOnPreExecute();
            }
            case 5: {
                return breakpoint.getOnPostExecute();
            }
            case 6: {
                return breakpoint.getOnPreOutput();
            }
            case 7: {
                return breakpoint.getOnPostOutput();
            }
            case 8: {
                return breakpoint.getClass().getSimpleName();
            }
            case 9: {
                if (breakpoint instanceof BooleanConditionSupporter) {
                    return ((BooleanConditionSupporter)((Object)breakpoint)).getCondition().getQuickInfo();
                }
                return null;
            }
            case 10: {
                if (breakpoint instanceof BooleanConditionSupporter) {
                    return OptionUtils.getCommandLine(((BooleanConditionSupporter)((Object)breakpoint)).getCondition());
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal column index: " + columnIndex);
    }

    public void clearBreakpoints() {
        this.m_Owner.getOwner().setBreakpoints(new AbstractBreakpoint[0]);
        this.fireTableDataChanged();
    }

    public AbstractBreakpoint getBreakpointAt(int rowIndex) {
        return this.m_Owner.getOwner().getBreakpoints()[rowIndex];
    }

    public void setBreakpointAt(int rowIndex, AbstractBreakpoint value) {
        this.m_Owner.getOwner().getBreakpoints()[rowIndex] = value;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void addBreakpoint(AbstractBreakpoint value) {
        ArrayList<AbstractBreakpoint> list = new ArrayList<AbstractBreakpoint>(Arrays.asList(this.m_Owner.getOwner().getBreakpoints()));
        list.add(value);
        this.m_Owner.getOwner().setBreakpoints(list.toArray(new AbstractBreakpoint[list.size()]));
        this.fireTableRowsUpdated(list.size() - 1, list.size() - 1);
    }

    public AbstractBreakpoint removeBreakpointAt(int rowIndex) {
        AbstractBreakpoint result = this.m_Owner.getOwner().getBreakpoints()[rowIndex];
        ArrayList<AbstractBreakpoint> list = new ArrayList<AbstractBreakpoint>(Arrays.asList(this.m_Owner.getOwner().getBreakpoints()));
        list.remove(rowIndex);
        this.m_Owner.getOwner().setBreakpoints(list.toArray(new AbstractBreakpoint[list.size()]));
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return result;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }
}

