/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.OptionHandler;
import adams.core.option.OptionTraversalPath;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.processor.AbstractListingProcessor;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.flow.FlowPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractListNameUsage<T>
extends AbstractListingProcessor {
    private static final long serialVersionUID = 7133896476260133469L;
    protected String m_Name;
    protected transient AbstractActor m_Current;

    @Override
    public abstract String globalInfo();

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", "");
    }

    public void setName(String value) {
        this.m_Name = value;
        this.reset();
    }

    public String getName() {
        return this.m_Name;
    }

    public abstract String nameTipText();

    protected abstract boolean isNameMatch(Object var1);

    protected Actor findEnclosingActor(OptionHandler owner, OptionTraversalPath path, int index) {
        if (path.getObject(index) instanceof Actor) {
            return (Actor)path.getObject(index);
        }
        if (index > 0) {
            return this.findEnclosingActor(owner, path, index - 1);
        }
        return null;
    }

    protected Actor findEnclosingActor(OptionHandler owner, OptionTraversalPath path) {
        if (owner instanceof Actor) {
            return (Actor)owner;
        }
        return this.findEnclosingActor(owner, path, path.size() - 1);
    }

    protected String createLocation(OptionHandler owner, Object obj, OptionTraversalPath path) {
        Actor actor = this.findEnclosingActor(owner, path);
        if (actor != null) {
            return actor.getFullName();
        }
        return owner.getClass().getName();
    }

    @Override
    protected boolean isValid(OptionHandler handler, Object obj, OptionTraversalPath path) {
        return this.isNameMatch(obj);
    }

    @Override
    protected String objectToString(OptionHandler handler, Object obj, OptionTraversalPath path) {
        return this.createLocation(handler, obj, path);
    }

    @Override
    protected void processActor(AbstractActor actor) {
        this.m_Current = actor;
        super.processActor(actor);
    }

    @Override
    protected boolean isSortedList() {
        return true;
    }

    @Override
    protected boolean isUniqueList() {
        return true;
    }

    @Override
    public Component getGraphicalOutput() {
        JButton buttonJumpTo;
        final Flow flow = this.m_Current instanceof Flow ? (Flow)this.m_Current : (this.m_Current != null && this.m_Current.getRoot() instanceof Flow ? (Flow)this.m_Current.getRoot() : null);
        final BaseListWithButtons result = new BaseListWithButtons();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String item : this.m_List) {
            model.addElement(item);
        }
        result.setModel(model);
        final JButton buttonCopy = new JButton("Copy");
        buttonCopy.setEnabled(false);
        buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] values = result.getSelectedValues();
                StringBuilder content = new StringBuilder();
                for (Object value : values) {
                    if (content.length() > 0) {
                        content.append("\n");
                    }
                    content.append("" + value);
                }
                GUIHelper.copyToClipboard(content.toString());
            }
        });
        result.addToButtonsPanel(buttonCopy);
        if (flow != null && flow.getParentComponent() != null) {
            buttonJumpTo = new JButton("Jump to");
            buttonJumpTo.setEnabled(false);
            buttonJumpTo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (result.getSelectedIndex() > -1 && flow.getParentComponent() instanceof FlowPanel) {
                        ((FlowPanel)flow.getParentComponent()).getTree().locateAndDisplay("" + result.getSelectedValue());
                    }
                }
            });
            result.addToButtonsPanel(buttonJumpTo);
        } else {
            buttonJumpTo = null;
        }
        result.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                buttonCopy.setEnabled(result.getSelectedIndices().length > 0);
                if (buttonJumpTo != null) {
                    buttonJumpTo.setEnabled(result.getSelectedIndices().length == 1);
                }
            }
        });
        return result;
    }
}

