/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.base.BaseAnnotation;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.core.option.OptionTraversalPath;
import adams.flow.core.Actor;
import adams.flow.processor.AbstractListingProcessor;
import java.util.List;

public class ListAnnotationTags
extends AbstractListingProcessor {
    private static final long serialVersionUID = -1049176597434370431L;
    protected BaseRegExp m_RegExp;

    @Override
    public String globalInfo() {
        return "Lists all tags in actor annotations.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the tags must match.";
    }

    @Override
    public String getTitle() {
        return "Tags matching '" + this.m_RegExp + "'";
    }

    @Override
    protected boolean isValid(OptionHandler handler, Object obj, OptionTraversalPath path) {
        boolean result = obj instanceof Actor;
        if (result) {
            BaseAnnotation ann = ((Actor)obj).getAnnotations();
            if (this.m_RegExp.isMatchAll()) {
                result = ann.hasTag();
            } else {
                result = false;
                List<BaseAnnotation.Tag> tags = ann.getTags();
                for (BaseAnnotation.Tag tag : tags) {
                    if (!this.m_RegExp.isMatch(tag.getName())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    protected String objectToString(OptionHandler handler, Object obj, OptionTraversalPath path) {
        Actor actor = (Actor)obj;
        String result = actor.getFullName().indexOf(44) > -1 ? "\"" + actor.getFullName() + "\"" : actor.getFullName();
        String tagStr = "";
        List<BaseAnnotation.Tag> tags = actor.getAnnotations().getTags();
        for (BaseAnnotation.Tag tag : tags) {
            if (!this.m_RegExp.isMatch(tag.getName())) continue;
            if (tagStr.length() > 0) {
                tagStr = tagStr + ", ";
            }
            tagStr = tagStr + tag.getName();
        }
        result = tagStr.length() == 0 ? null : result + ",\"" + tagStr + "\"";
        return result;
    }

    @Override
    protected void finalizeList() {
        super.finalizeList();
        if (this.m_List.size() > 0) {
            String header = "Actor,";
            header = header + "Tag(s)";
            this.m_List.add(0, header);
        }
    }

    @Override
    protected boolean isSortedList() {
        return true;
    }

    @Override
    protected boolean isUniqueList() {
        return true;
    }

    @Override
    protected String getHeader() {
        return "Tags found:";
    }
}

