/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.setup;

import adams.core.Pausable;
import adams.core.Stoppable;
import adams.core.io.FlowFile;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.event.FlowSetupStateEvent;
import adams.event.FlowSetupStateListener;
import adams.flow.core.AbstractActor;
import adams.flow.setup.FlowSetupManager;
import adams.flow.setup.FlowSetupWorker;
import java.util.HashSet;
import java.util.Iterator;

public class FlowSetup
extends AbstractOptionHandler
implements Comparable,
Stoppable,
Pausable {
    private static final long serialVersionUID = -1802605995073395422L;
    protected FlowFile m_File;
    protected String m_Name;
    protected String m_Description;
    protected boolean m_Headless;
    protected String m_OnFinish;
    protected String m_OnError;
    protected transient FlowSetupWorker m_FlowSetupWorker;
    protected AbstractActor m_LastActor;
    protected transient String m_LastError;
    protected transient HashSet<FlowSetupStateListener> m_FlowSetupStateListeners;
    protected transient FlowSetupManager m_Manager;

    @Override
    public String globalInfo() {
        return "Container object for a flow file with name and information about it.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", "noname");
        this.m_OptionManager.add("description", "description", "nodescription");
        this.m_OptionManager.add("file", "file", new FlowFile("."));
        this.m_OptionManager.add("headless", "headless", false);
        this.m_OptionManager.add("on-error", "onError", "");
        this.m_OptionManager.add("on-finish", "onFinish", "");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FlowSetupWorker = null;
        this.m_LastActor = null;
        this.m_LastError = null;
        this.m_Manager = null;
    }

    protected HashSet<FlowSetupStateListener> getFlowSetupStateChangeListeners() {
        if (this.m_FlowSetupStateListeners == null) {
            this.m_FlowSetupStateListeners = new HashSet();
        }
        return this.m_FlowSetupStateListeners;
    }

    public void setFile(FlowFile value) {
        this.m_File = value;
    }

    public FlowFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The flow file.";
    }

    public void setName(String value) {
        this.m_Name = value;
    }

    public String getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The name of the flow.";
    }

    public void setDescription(String value) {
        this.m_Description = value;
    }

    public String getDescription() {
        return this.m_Description;
    }

    public String descriptionTipText() {
        return "The description of the flow.";
    }

    public void setHeadless(boolean value) {
        this.m_Headless = value;
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public String headlessTipText() {
        return "If set to true, the flow is run in headless mode without GUI components.";
    }

    public void setOnFinish(String value) {
        if (value == null) {
            value = "";
        }
        if (value.equals(this.m_Name)) {
            this.getLogger().severe("Circular reference!");
            return;
        }
        this.m_OnFinish = value;
    }

    public String getOnFinish() {
        return this.m_OnFinish;
    }

    public String onFinishTipText() {
        return "The name of the flow setup to execute when this setup finishes.";
    }

    public boolean hasOnFinish() {
        return this.m_OnFinish.length() > 0;
    }

    public void setOnError(String value) {
        if (value == null) {
            value = "";
        }
        if (value.equals(this.m_Name)) {
            this.getLogger().severe("Circular reference!");
            return;
        }
        this.m_OnError = value;
    }

    public String getOnError() {
        return this.m_OnError;
    }

    public String onErrorTipText() {
        return "The name of the flow setup to execute when this setup exist with an error.";
    }

    public boolean hasOnError() {
        return this.m_OnError.length() > 0;
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public void setLastError(String value) {
        this.m_LastError = value;
        if (value != null) {
            this.showStatus("Error ('" + this.m_Name + "'): " + value);
        } else {
            this.showStatus("");
        }
    }

    public String retrieveLastError() {
        return this.m_LastError;
    }

    public void setOwner(FlowSetupManager value) {
        this.m_Manager = value;
    }

    public FlowSetupManager getOwner() {
        return this.m_Manager;
    }

    public void showStatus(String msg) {
        if (this.getOwner() != null && this.getOwner().getStatusMessageHandler() != null) {
            this.getOwner().getStatusMessageHandler().showStatus(msg);
        }
    }

    public boolean isRunning() {
        return this.m_FlowSetupWorker != null;
    }

    @Override
    public void pauseExecution() {
        if (this.m_FlowSetupWorker != null) {
            this.m_FlowSetupWorker.pauseExecution();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.m_FlowSetupWorker != null) {
            return this.m_FlowSetupWorker.isPaused();
        }
        return false;
    }

    @Override
    public void resumeExecution() {
        if (this.m_FlowSetupWorker != null) {
            this.m_FlowSetupWorker.resumeExecution();
        }
    }

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean wait) {
        if (this.m_FlowSetupWorker != null) {
            this.setLastError("Is the flow still running?");
            return false;
        }
        this.showStatus("");
        this.cleanUp();
        if (!this.m_File.exists()) {
            this.setLastError("Flow file '" + this.m_File + "' does not exist!");
            return false;
        }
        if (this.m_File.isDirectory()) {
            this.setLastError("Flow file '" + this.m_File + "' points to a directory!");
            return false;
        }
        this.showStatus("Running: " + this.m_Name + " (" + this.m_File + ")");
        this.m_LastActor = null;
        this.m_FlowSetupWorker = new FlowSetupWorker(this);
        this.m_FlowSetupWorker.execute();
        if (wait) {
            while (this.isRunning()) {
                try {
                    this.wait(200L);
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    @Override
    public void stopExecution() {
        if (this.m_FlowSetupWorker != null) {
            this.m_FlowSetupWorker.stopExecution();
        }
    }

    public void finish() {
        this.m_LastActor = this.m_FlowSetupWorker.getLastActor();
        this.m_FlowSetupWorker.cleanUp();
        this.m_FlowSetupWorker = null;
    }

    public void cleanUp() {
        if (this.m_LastActor != null) {
            this.m_LastActor.cleanUp();
            this.m_LastActor = null;
        }
    }

    public void addFlowSetupStateChangeListener(FlowSetupStateListener l) {
        this.getFlowSetupStateChangeListeners().add(l);
    }

    public void removeFlowSetupStateChangeListener(FlowSetupStateListener l) {
        this.getFlowSetupStateChangeListeners().remove(l);
    }

    public void notifyFlowSetupStateChangeListeners(FlowSetupStateEvent e) {
        Iterator<FlowSetupStateListener> iter = this.getFlowSetupStateChangeListeners().iterator();
        while (iter.hasNext()) {
            iter.next().flowSetupStateChanged(e);
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public FlowSetup shallowCopy() {
        return this.shallowCopy(false);
    }

    public FlowSetup shallowCopy(boolean expand) {
        return (FlowSetup)OptionUtils.shallowCopy(this, expand);
    }
}

