/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.print.NullWriter;
import adams.gui.print.PNGWriter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractGraphicalDisplay
extends AbstractDisplay
implements MenuBarProvider,
ComponentSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = -4882859296402745911L;
    protected JComponentWriter m_Writer;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileClear;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileSaveTextAs;
    protected JMenuItem m_MenuItemFileClose;
    protected transient JComponentWriterFileChooser m_GraphicFileChooser;
    protected transient TextFileChooser m_TextFileChooser;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    public void setWriter(JComponentWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public JComponentWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for generating the graphics output.";
    }

    protected boolean hasPanel() {
        return this.supplyComponent() != null;
    }

    @Override
    public JComponent supplyComponent() {
        return this.m_Panel;
    }

    protected JComponentWriterFileChooser getGraphicFileChooser() {
        if (this.m_GraphicFileChooser == null) {
            this.m_GraphicFileChooser = new JComponentWriterFileChooser();
        }
        return this.m_GraphicFileChooser;
    }

    protected TextFileChooser getTextFileChooser() {
        if (this.m_TextFileChooser == null) {
            ExtensionFileFilter filter;
            TextFileChooser fileChooser = new TextFileChooser();
            if (this instanceof TextSupplier && (filter = ((TextSupplier)((Object)this)).getCustomTextFileFilter()) != null) {
                fileChooser.resetChoosableFileFilters();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            }
            this.m_TextFileChooser = fileChooser;
        }
        return this.m_TextFileChooser;
    }

    protected JMenuBar createMenuBar() {
        JMenuItem menuitem;
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        result.add(menu);
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractGraphicalDisplay.this.updateMenu();
            }
        });
        if (this.supportsClear()) {
            menuitem = new JMenuItem("Clear");
            menu.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon("new.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractGraphicalDisplay.this.clear();
                }
            });
            this.m_MenuItemFileClear = menuitem;
        }
        menuitem = new JMenuItem("Save as...");
        menu.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGraphicalDisplay.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        if (this instanceof TextSupplier) {
            menuitem = new JMenuItem("Save text as...");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractGraphicalDisplay.this.saveTextAs();
                }
            });
            this.m_MenuItemFileSaveTextAs = menuitem;
        }
        menu.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        menu.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGraphicalDisplay.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSaveAs.setEnabled(this.hasPanel());
        if (this.m_MenuItemFileSaveTextAs != null) {
            this.m_MenuItemFileSaveTextAs.setEnabled(this.hasPanel());
        }
    }

    protected boolean supportsClear() {
        return false;
    }

    protected void clear() {
    }

    protected void saveAs() {
        int retVal = this.getGraphicFileChooser().showSaveDialog(this.m_Panel);
        if (retVal != 0) {
            return;
        }
        JComponentWriter writer = this.getGraphicFileChooser().getWriter();
        writer.setComponent(this.supplyComponent());
        try {
            writer.toOutput();
        }
        catch (Exception e) {
            this.handleException("Error saving panel to '" + writer.getFile() + "': ", e);
        }
    }

    protected void saveTextAs() {
        int retVal = this.getTextFileChooser().showSaveDialog(this.m_Panel);
        if (retVal != 0) {
            return;
        }
        String msg = FileUtils.writeToFileMsg(this.getTextFileChooser().getSelectedFile().getAbsolutePath(), ((TextSupplier)((Object)this)).supplyText(), false, this.getTextFileChooser().getEncoding());
        if (msg != null) {
            this.getLogger().severe("Error saving text to '" + this.getTextFileChooser().getSelectedFile() + "':\n" + msg);
        }
    }

    protected void close() {
        this.m_Panel.closeParent();
    }

    @Override
    protected void cleanUpGUI() {
        super.cleanUpGUI();
        this.m_MenuBar = null;
        this.m_MenuItemFileClear = null;
        this.m_MenuItemFileSaveAs = null;
        this.m_MenuItemFileSaveTextAs = null;
        this.m_MenuItemFileClose = null;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JComponent.class}, cls) && this.supplyComponent() != null;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        JComponent comp = this.supplyComponent();
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            if (comp != null) {
                result = SendToActionUtils.nextTmpFile("actor-" + this.getName(), "png");
                PNGWriter writer = new PNGWriter();
                writer.setFile((PlaceholderFile)result);
                writer.setComponent(comp);
                try {
                    writer.generateOutput();
                }
                catch (Exception e) {
                    this.handleException("Failed to write image to " + result + ":", e);
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            result = comp;
        }
        return result;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        if (!(this.m_Writer instanceof NullWriter) && this.supplyComponent() != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractGraphicalDisplay.this.m_Writer.setComponent(AbstractGraphicalDisplay.this.supplyComponent());
                        AbstractGraphicalDisplay.this.m_Writer.toOutput();
                    }
                    catch (Exception e) {
                        AbstractGraphicalDisplay.this.handleException("Failed to write graphical output", e);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }
}

