/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.MultiAttemptWithWaitSupporter;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.FileEncodingSupporter;
import adams.core.io.FileUtils;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractAppendableFileWriter;

public class DumpFile
extends AbstractAppendableFileWriter
implements FileEncodingSupporter,
MultiAttemptWithWaitSupporter {
    private static final long serialVersionUID = -366362262032858011L;
    protected BaseCharset m_Encoding;
    protected int m_NumAttempts;
    protected int m_AttemptInterval;

    @Override
    public String globalInfo() {
        return "Actor that just dumps any input token into a separate line of the specified output file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", new BaseCharset());
        this.m_OptionManager.add("num-attempts", "numAttempts", 1, 1, null);
        this.m_OptionManager.add("attempt-interval", "attemptInterval", 1000, 0, null);
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public String appendTipText() {
        return "If set to true, file gets only appended.";
    }

    @Override
    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    @Override
    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    @Override
    public String encodingTipText() {
        return "The type of encoding to use when writing to the file, use empty string for default.";
    }

    @Override
    public void setNumAttempts(int value) {
        if (value >= 1) {
            this.m_NumAttempts = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of attempts must at least 1, provided: " + value);
        }
    }

    @Override
    public int getNumAttempts() {
        return this.m_NumAttempts;
    }

    @Override
    public String numAttemptsTipText() {
        return "The number of attempts for writing the data.";
    }

    @Override
    public void setAttemptInterval(int value) {
        if (this.getOptionManager().isValid("numAttempts", value)) {
            this.m_AttemptInterval = value;
            this.reset();
        }
    }

    @Override
    public int getAttemptInterval() {
        return this.m_AttemptInterval;
    }

    @Override
    public String attemptIntervalTipText() {
        return "The time in msec to wait before the next attempt.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        int attempt = 0;
        boolean finished = false;
        while (!finished) {
            result = FileUtils.writeToFileMsg(this.m_OutputFile.getAbsolutePath(), this.m_InputToken.getPayload(), this.m_Append, this.m_Encoding.charsetValue().name());
            if ((finished = ++attempt == this.m_NumAttempts || result == null) || result == null) continue;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Attempt " + attempt + "/" + this.m_NumAttempts + " failed, retrying...");
            }
            if (this.m_AttemptInterval <= 0) continue;
            Utils.wait(this, this, this.m_AttemptInterval, 100);
        }
        return result;
    }
}

