/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.management.LoggingObjectOutputPrinter;
import adams.core.management.OutputProcessStream;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.AnyToString;
import adams.data.conversion.ConversionToString;
import adams.flow.sink.AbstractSink;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Hashtable;

public class Exec
extends AbstractSink {
    private static final long serialVersionUID = -5040421332565191432L;
    public static final String BACKUP_PROCESS = "process";
    public static final String BACKUP_WRITER = "writer";
    public static final String BACKUP_OUTPUTPROCESSOR_STDOUT = "output processor stdout";
    public static final String BACKUP_OUTPUTPROCESSOR_STDERR = "output processor stderr";
    protected String m_Command;
    protected ConversionToString m_Conversion;
    protected String m_Delimiter;
    protected String m_FinishedSignal;
    protected Process m_Process;
    protected BufferedWriter m_Writer;
    protected OutputProcessStream m_Stdout;
    protected OutputProcessStream m_Stderr;

    @Override
    public String globalInfo() {
        return "Pipes the incoming data, after converting it using the provided conversion scheme, into the started process.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", "mysql test");
        this.m_OptionManager.add("conversion", "conversion", new AnyToString());
        this.m_OptionManager.add("delimiter", "delimiter", "\\n");
        this.m_OptionManager.add("finished-signal", "finishedSignal", "");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "command", this.m_Command, "Command: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "conversion", this.m_Conversion, ", Conversion: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "delimiter", Utils.backQuoteChars(this.m_Delimiter), ", Delimiter: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, "finishedSignal", Utils.backQuoteChars(this.m_FinishedSignal).replace("\\\\u", "\\u"), ", finished Signal: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_Process != null) {
            result.put(BACKUP_PROCESS, this.m_Process);
        }
        if (this.m_Writer != null) {
            result.put(BACKUP_WRITER, this.m_Writer);
        }
        if (this.m_Stdout != null) {
            result.put(BACKUP_OUTPUTPROCESSOR_STDOUT, this.m_Stdout);
        }
        if (this.m_Stderr != null) {
            result.put(BACKUP_OUTPUTPROCESSOR_STDERR, this.m_Stderr);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_PROCESS)) {
            this.m_Process = (Process)state.get(BACKUP_PROCESS);
            state.remove(BACKUP_PROCESS);
        }
        if (state.containsKey(BACKUP_WRITER)) {
            this.m_Writer = (BufferedWriter)state.get(BACKUP_WRITER);
            state.remove(BACKUP_WRITER);
        }
        if (state.containsKey(BACKUP_OUTPUTPROCESSOR_STDOUT)) {
            this.m_Stdout = (OutputProcessStream)state.get(BACKUP_OUTPUTPROCESSOR_STDOUT);
            state.remove(BACKUP_OUTPUTPROCESSOR_STDOUT);
        }
        if (state.containsKey(BACKUP_OUTPUTPROCESSOR_STDERR)) {
            this.m_Stderr = (OutputProcessStream)state.get(BACKUP_OUTPUTPROCESSOR_STDERR);
            state.remove(BACKUP_OUTPUTPROCESSOR_STDERR);
        }
        super.restoreState(state);
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_PROCESS);
        this.pruneBackup(BACKUP_WRITER);
        this.pruneBackup(BACKUP_OUTPUTPROCESSOR_STDOUT);
        this.pruneBackup(BACKUP_OUTPUTPROCESSOR_STDERR);
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to pipe the data into.";
    }

    public void setConversion(ConversionToString value) {
        this.m_Conversion = value;
        this.reset();
    }

    public ConversionToString getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion scheme to apply to the input tokens.";
    }

    public void setDelimiter(String value) {
        this.m_Delimiter = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getDelimiter() {
        return Utils.backQuoteChars(this.m_Delimiter);
    }

    public String delimiterTipText() {
        return "The delimiter string to forward to the process after each token; uses backquoted strings, ie you can use \\n for new line and \\r for carriage return.";
    }

    public void setFinishedSignal(String value) {
        this.m_FinishedSignal = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getFinishedSignal() {
        return Utils.backQuoteChars(this.m_FinishedSignal).replace("\\\\u", "\\u");
    }

    public String finishedSignalTipText() {
        return "The string to signal the process that the processing has finished; gets ignored if empty string; you can use \\uXXXX for unicode characters (with XXXX being a hexadecimal number), eg \\u001a for EOF.";
    }

    protected String getActualFinishedSignal() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_FinishedSignal.length(); ++i) {
            char curr = this.m_FinishedSignal.charAt(i);
            int next = -1;
            if (i < this.m_FinishedSignal.length() - 1) {
                next = this.m_FinishedSignal.charAt(i + 1);
            }
            if (next == -1) continue;
            if (curr == '\\' && next == 117 && i < this.m_FinishedSignal.length() - 5) {
                result.append(Character.toChars(Integer.parseInt(this.m_FinishedSignal.substring(i + 2, i + 6), 16)));
                i += 5;
                continue;
            }
            result.append(curr);
        }
        return result.toString();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{this.m_Conversion.accepts()};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_Process == null) {
            try {
                String[] cmd = OptionUtils.splitOptions(this.m_Command);
                this.m_Process = Runtime.getRuntime().exec(cmd);
                this.m_Writer = new BufferedWriter(new OutputStreamWriter(this.m_Process.getOutputStream()));
                this.m_Stdout = new OutputProcessStream(this.m_Process, LoggingObjectOutputPrinter.class, true);
                this.m_Stderr = new OutputProcessStream(this.m_Process, LoggingObjectOutputPrinter.class, false);
                ((LoggingObjectOutputPrinter)this.m_Stdout.getPrinter()).setOwner(this);
                ((LoggingObjectOutputPrinter)this.m_Stderr.getPrinter()).setOwner(this);
                new Thread(this.m_Stdout).start();
                new Thread(this.m_Stderr).start();
            }
            catch (Exception e) {
                this.m_Writer = null;
                this.handleException("Failed to execute command: " + this.m_Command, e);
            }
        }
        if (this.m_Writer != null) {
            this.m_Conversion.setInput(this.m_InputToken.getPayload());
            String msg = this.m_Conversion.convert();
            if (msg == null) {
                try {
                    this.m_Writer.write((String)this.m_Conversion.getOutput());
                    this.m_Writer.write(this.m_Delimiter);
                    this.m_Writer.flush();
                }
                catch (Exception e) {
                    this.handleException("Failed to pipe data:", e);
                }
            } else {
                result = "Failed to convert token: " + msg;
            }
        }
        return result;
    }

    @Override
    public void wrapUp() {
        if (this.m_Stdout != null) {
            this.m_Stdout.stop();
            this.m_Stdout = null;
        }
        if (this.m_Stderr != null) {
            this.m_Stderr.stop();
            this.m_Stderr = null;
        }
        if (this.m_Writer != null) {
            String finished = this.getActualFinishedSignal();
            try {
                if (finished.length() > 0) {
                    this.m_Writer.write(finished);
                    this.m_Writer.flush();
                }
                this.m_Writer.close();
            }
            catch (Exception e) {
                this.handleException("Failed to close pipe:", e);
            }
            this.m_Writer = null;
        }
        super.wrapUp();
    }
}

