/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.tools.PreviewBrowserPanel;
import adams.gui.tools.previewbrowser.AbstractArchiveHandler;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoDataToPreviewPanel;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PlainTextHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FilePreview
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 1523870513962160664L;
    protected PreviewPanel m_PreviewPanel;
    protected boolean m_UseCustomPreview;
    protected AbstractContentHandler m_Preview;

    @Override
    public String globalInfo() {
        return "Actor for previewing file contents. Skips archives (if handlers available).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-custom-preview", "useCustomPreview", false);
        this.m_OptionManager.add("preview", "preview", new PlainTextHandler());
    }

    @Override
    protected int getDefaultWidth() {
        return 800;
    }

    @Override
    protected int getDefaultHeight() {
        return 600;
    }

    public void setUseCustomPreview(boolean value) {
        this.m_UseCustomPreview = value;
        this.reset();
    }

    public boolean getUseCustomPreview() {
        return this.m_UseCustomPreview;
    }

    public String useCustomPreviewTipText() {
        return "If enabled the specified preview handler is used for all files rather than 'automagically' determined.";
    }

    public void setPreview(AbstractContentHandler value) {
        this.m_Preview = value;
        this.reset();
    }

    public AbstractContentHandler getPreview() {
        return this.m_Preview;
    }

    public String previewTipText() {
        return "The custom preview to use.";
    }

    @Override
    public String getQuickInfo() {
        String result = null;
        result = QuickInfoHelper.hasVariable(this, "useCustomPreview") || this.m_UseCustomPreview ? QuickInfoHelper.toString((OptionHandler)this, "preview", Utils.shorten(OptionUtils.getShortCommandLine(this.getPreview()), 40)) : "automatic";
        return result;
    }

    @Override
    public void clearPanel() {
        if (this.m_PreviewPanel != null) {
            this.m_PreviewPanel.removeAll();
            this.m_PreviewPanel.getParent().invalidate();
            this.m_PreviewPanel.getParent().validate();
            this.m_PreviewPanel.repaint();
        }
    }

    @Override
    protected BasePanel newPanel() {
        this.m_PreviewPanel = new PreviewPanel(new NoPreviewAvailablePanel());
        return this.m_PreviewPanel;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class, BufferedImage.class, AbstractImageContainer.class};
    }

    @Override
    protected void display(Token token) {
        PlaceholderFile file;
        if (token.getPayload() instanceof String) {
            file = new PlaceholderFile((String)token.getPayload());
        } else if (token.getPayload() instanceof File) {
            file = new PlaceholderFile((File)token.getPayload());
        } else {
            throw new IllegalStateException("Unhandled data type: " + Utils.classToString(token.getPayload().getClass()));
        }
        JPanel parent = (JPanel)this.m_PreviewPanel.getParent();
        parent.remove(this.m_PreviewPanel);
        this.m_PreviewPanel = null;
        if (!AbstractArchiveHandler.hasHandler(file)) {
            if (this.getUseCustomPreview()) {
                this.m_PreviewPanel = new PreviewPanel(this.getPreview().getPreview(file));
                parent.add((Component)this.m_PreviewPanel, "Center");
            } else {
                AbstractContentHandler preview = PreviewBrowserPanel.getPreferredContentHandler(file);
                if (preview != null) {
                    this.m_PreviewPanel = new PreviewPanel(preview.getPreview(file));
                }
            }
        }
        if (this.m_PreviewPanel != null) {
            parent.add((Component)this.m_PreviewPanel, "Center");
        }
    }

    @Override
    public DisplayPanel createDisplayPanel(Token token) {
        FilePreviewDisplayPanel result = new FilePreviewDisplayPanel(this);
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public static class FilePreviewDisplayPanel
    extends AbstractComponentDisplayPanel {
        private static final long serialVersionUID = -3054275069984068238L;
        protected FilePreview m_Owner;
        protected PreviewPanel m_PreviewPanel;

        public FilePreviewDisplayPanel(FilePreview owner) {
            super(owner.getClass().getName());
            this.m_Owner = owner;
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PreviewPanel = new PreviewPanel(new NoDataToPreviewPanel());
            this.add((Component)this.m_PreviewPanel, "Center");
        }

        @Override
        public void display(Token token) {
            PlaceholderFile file;
            if (token.getPayload() instanceof String) {
                file = new PlaceholderFile((String)token.getPayload());
            } else if (token.getPayload() instanceof File) {
                file = new PlaceholderFile((File)token.getPayload());
            } else {
                throw new IllegalStateException("Unhandled data type: " + Utils.classToString(token.getPayload().getClass()));
            }
            JPanel parent = (JPanel)this.m_PreviewPanel.getParent();
            parent.remove(this.m_PreviewPanel);
            this.m_PreviewPanel = null;
            if (!AbstractArchiveHandler.hasHandler(file)) {
                if (this.m_Owner.getUseCustomPreview()) {
                    this.m_PreviewPanel = new PreviewPanel(this.m_Owner.getPreview().getPreview(file));
                    parent.add((Component)this.m_PreviewPanel, "Center");
                } else {
                    AbstractContentHandler preview = PreviewBrowserPanel.getPreferredContentHandler(file);
                    if (preview != null) {
                        this.m_PreviewPanel = new PreviewPanel(preview.getPreview(file));
                    }
                }
            }
            if (this.m_PreviewPanel != null) {
                parent.add((Component)this.m_PreviewPanel, "Center");
            }
        }

        @Override
        public void cleanUp() {
        }

        @Override
        public void clearPanel() {
            this.m_PreviewPanel.removeAll();
            this.m_PreviewPanel.getParent().invalidate();
            this.m_PreviewPanel.getParent().validate();
            this.m_PreviewPanel.repaint();
        }

        @Override
        public JComponent supplyComponent() {
            return this.m_PreviewPanel;
        }
    }
}

