/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.env.Environment;
import adams.event.TokenEvent;
import adams.event.TokenListener;
import adams.flow.control.Flow;
import adams.flow.core.Token;
import adams.flow.core.TokenEventHandler;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractSink;
import adams.flow.source.ForLoop;
import java.util.HashSet;

public class ProgrammaticSink
extends AbstractSink
implements TokenEventHandler {
    private static final long serialVersionUID = -5521515998670431523L;
    protected HashSet<TokenListener> m_TokenListeners;

    @Override
    public String globalInfo() {
        return "For programmatically hooking into a flow and receive tokens.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_TokenListeners = new HashSet();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        TokenEvent e = new TokenEvent(this, this.m_InputToken);
        this.notifyTokenListeners(e);
        return null;
    }

    @Override
    public void addTokenListener(TokenListener l) {
        this.m_TokenListeners.add(l);
    }

    @Override
    public void removeTokenListener(TokenListener l) {
        this.m_TokenListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenListener[] tokenListeners() {
        HashSet<TokenListener> hashSet = this.m_TokenListeners;
        synchronized (hashSet) {
            return this.m_TokenListeners.toArray(new TokenListener[this.m_TokenListeners.size()]);
        }
    }

    @Override
    public void notifyTokenListeners(TokenEvent e) {
        TokenListener[] listeners;
        for (TokenListener l : listeners = this.tokenListeners()) {
            l.processToken(e);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_TokenListeners.clear();
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        Flow flow = new Flow();
        ForLoop forloop = new ForLoop();
        flow.add(forloop);
        ProgrammaticSink psink = new ProgrammaticSink();
        psink.addTokenListener(new TokenListener(){

            @Override
            public void processToken(TokenEvent e) {
                Token token = e.getToken();
                TokenEventHandler handler = e.getHandler();
                System.out.println("handler=" + handler.getFullName() + ", token=" + token.getPayload());
            }
        });
        flow.add(psink);
        String result = flow.setUp();
        if (result != null) {
            System.err.println("Failed to set up flow: " + result);
            return;
        }
        result = flow.execute();
        if (result != null) {
            System.err.println("Failed to execute flow: " + result);
            flow.wrapUp();
            flow.cleanUp();
            return;
        }
        flow.wrapUp();
        flow.cleanUp();
    }
}

