/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import java.util.HashMap;

public class SequencePlotSequence
extends XYSequence {
    private static final long serialVersionUID = 331392414841660594L;

    @Override
    public SpreadSheet toSpreadSheet() {
        Double[] error;
        SequencePlotPoint spoint;
        boolean errorXLow = false;
        boolean errorXHigh = false;
        boolean errorYLow = false;
        boolean errorYHigh = false;
        for (XYSequencePoint point : this) {
            if (!(point instanceof SequencePlotPoint)) continue;
            spoint = (SequencePlotPoint)point;
            if (!errorXLow && spoint.hasErrorX()) {
                errorXLow = true;
                error = spoint.getErrorX();
                if (error.length > 1) {
                    errorXHigh = true;
                }
            }
            if (errorYLow || !spoint.hasErrorY()) continue;
            errorYLow = true;
            error = spoint.getErrorY();
            if (error.length <= 1) continue;
            errorYHigh = true;
        }
        SpreadSheet result = new SpreadSheet();
        result.setDataRowClass(SparseDataRow.class);
        result.setName(this.getID());
        Row row = result.getHeaderRow();
        row.addCell("ID").setContent("ID");
        row.addCell("X").setContent("X");
        row.addCell("Y").setContent("Y");
        if (errorXLow) {
            row.addCell("EX1").setContent("Error X (low/delta)");
        }
        if (errorXHigh) {
            row.addCell("EX2").setContent("Error X (high)");
        }
        if (errorYLow) {
            row.addCell("EY1").setContent("Error Y (low/delta)");
        }
        if (errorYHigh) {
            row.addCell("EY2").setContent("Error Y (high)");
        }
        for (XYSequencePoint point : this) {
            row = result.addRow();
            row.addCell("ID").setContent(point.getID());
            if (this.hasMappingX()) {
                row.addCell("X").setContent(this.getMappingX(point.getX()));
            } else {
                row.addCell("X").setContent(point.getX());
            }
            if (this.hasMappingY()) {
                row.addCell("Y").setContent(this.getMappingY(point.getY()));
            } else {
                row.addCell("Y").setContent(point.getY());
            }
            if ((errorXLow || errorXHigh || errorYLow || errorYHigh) && point instanceof SequencePlotPoint) {
                spoint = (SequencePlotPoint)point;
                if ((errorXLow || errorXHigh) && spoint.hasErrorX()) {
                    error = spoint.getErrorX();
                    row.addCell("EX1").setContent(error[0]);
                    if (error.length > 1) {
                        row.addCell("EX2").setContent(error[1]);
                    }
                }
                if ((errorYLow || errorYHigh) && spoint.hasErrorY()) {
                    error = spoint.getErrorY();
                    row.addCell("EY1").setContent(error[0]);
                    if (error.length > 1) {
                        row.addCell("EY2").setContent(error[1]);
                    }
                }
            }
            if (!(point instanceof SequencePlotPoint) || !(spoint = (SequencePlotPoint)point).hasMetaData()) continue;
            HashMap<String, Object> meta = spoint.getMetaData();
            for (String key : meta.keySet()) {
                if (result.getHeaderRow().getCell("MetaData-" + key) == null) {
                    result.getHeaderRow().addCell("MetaData-" + key).setContent("MetaData-" + key);
                }
                row.addCell("MetaData-" + key).setNative(meta.get(key));
            }
        }
        return result;
    }
}

