/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractArrayProvider;
import java.util.ArrayList;

public abstract class AbstractIdSupplier
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8462709950859959951L;
    protected boolean m_Lenient;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lenient", "lenient", false);
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, the source no longer reports an error when not finding any IDs.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.m_OutputArray ? "as array" : "one by one");
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the IDs as array or one by one.";
    }

    @Override
    protected Class getItemClass() {
        return Integer.class;
    }

    protected abstract ArrayList getIDs(StringBuilder var1);

    @Override
    protected String doExecute() {
        String result = null;
        StringBuilder errors = new StringBuilder();
        this.m_Queue = this.getIDs(errors);
        if (errors.length() > 0) {
            result = errors.toString();
        } else if (this.m_Queue.size() == 0 && !this.m_Lenient) {
            result = "No IDs found!";
        }
        return result;
    }
}

