/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.db.AbstractDatabaseConnection;
import adams.db.InstrumentProvider;
import adams.flow.source.AbstractArrayProvider;
import java.util.ArrayList;

public abstract class AbstractInstrumentSupplier
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8159720259695436880L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to return the instruments as array or one by one.";
    }

    protected abstract InstrumentProvider getProvider();

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    protected String setUpDatabaseConnection() {
        String result = null;
        if (this.m_DatabaseConnection == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                result = "No database connection available!";
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = this.setUpDatabaseConnection();
        if (result == null) {
            InstrumentProvider provider = this.getProvider();
            this.m_Queue = new ArrayList<String>(provider.getInstruments());
            if (this.m_Queue.size() == 0) {
                result = "No instruments found!";
            }
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

