/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.flow.source.AbstractArrayProvider;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractListTables
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8462709950859959951L;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    public String globalInfo() {
        return "Lists tables of the current database connection.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, this.m_Invert ? "! " : "");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.getOutputArray(), "array"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the table names in an array rather than one by one.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the table names.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    protected String setUpDatabaseConnection() {
        String result = null;
        if (this.m_DatabaseConnection == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                result = "No database connection available!";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = this.setUpDatabaseConnection();
        ArrayList<String> tables = new ArrayList<String>();
        if (result == null) {
            ResultSet rs = null;
            try {
                rs = this.m_DatabaseConnection.getConnection(false).getMetaData().getTables(null, null, "%", null);
                while (rs.next()) {
                    tables.add(rs.getString(3));
                }
                SQL.closeAll(rs);
            }
            catch (Exception e) {
                result = this.handleException("Failed to obtain list of tables!", e);
            }
            finally {
                SQL.closeAll(rs);
            }
        }
        if (result == null) {
            if (this.m_RegExp.isMatchAll()) {
                if (!this.m_Invert) {
                    this.m_Queue.addAll(tables);
                }
            } else {
                for (String name : tables) {
                    if (this.m_Invert && !this.m_RegExp.isMatch(name)) {
                        this.m_Queue.add(name);
                        continue;
                    }
                    if (this.m_Invert || !this.m_RegExp.isMatch(name)) continue;
                    this.m_Queue.add(name);
                }
            }
            Collections.sort(this.m_Queue);
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

