/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.util.ArrayList;
import java.util.Collections;

public class DumpVariables
extends AbstractSimpleSource {
    private static final long serialVersionUID = -6626384935427295809L;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Outputs a spreadsheet with the variable names and their associated values.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, this.m_Invert ? "! " : "");
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the variable names.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    @Override
    protected String doExecute() {
        ArrayList<String> names = new ArrayList<String>();
        Variables var = this.getVariables();
        if (this.m_RegExp.isMatchAll()) {
            if (!this.m_Invert) {
                names.addAll(var.nameSet());
            }
        } else {
            for (String name : var.nameSet()) {
                if (this.m_Invert && !this.m_RegExp.isMatch(name)) {
                    names.add(name);
                    continue;
                }
                if (this.m_Invert || !this.m_RegExp.isMatch(name)) continue;
                names.add(name);
            }
        }
        Collections.sort(names);
        SpreadSheet sheet = new SpreadSheet();
        sheet.setName("Variables");
        Row row = sheet.getHeaderRow();
        row.addCell("K").setContent("Name");
        row.addCell("V").setContent("Value");
        for (String name : names) {
            row = sheet.addRow();
            row.addCell("K").setContentAsString(name);
            row.addCell("V").setContentAsString(var.get(name));
        }
        this.m_OutputToken = new Token(sheet);
        return null;
    }
}

