/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractSimpleSource;

public class NewReport
extends AbstractSimpleSource {
    private static final long serialVersionUID = 7272049518765623563L;
    protected String m_ReportClass;

    @Override
    public String globalInfo() {
        return "Generates a new instance of the specified report class.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("report-class", "reportClass", this.getDefaultReportClass());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "reportClass", this.m_ReportClass.length() != 0 ? this.m_ReportClass : "-from 1st element-", "Class: ");
    }

    protected String getDefaultReportClass() {
        return Report.class.getName();
    }

    public void setReportClass(String value) {
        this.m_ReportClass = value;
        this.reset();
    }

    public String getReportClass() {
        return this.m_ReportClass;
    }

    public String reportClassTipText() {
        return "The class to use for the report.";
    }

    @Override
    public Class[] generates() {
        Class[] result;
        if (this.m_ReportClass.length() > 0) {
            try {
                result = new Class[]{Class.forName(this.m_ReportClass)};
            }
            catch (Exception e) {
                result = new Class[]{};
            }
        } else {
            result = new Class[]{Unknown.class};
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Report report = (Report)Class.forName(this.m_ReportClass).newInstance();
            this.m_OutputToken = new Token(report);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate report!", e);
        }
        return result;
    }
}

