/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.gui.clipboard.AbstractClipboardData;
import adams.gui.clipboard.String;
import javax.swing.JOptionPane;

public class PasteFromClipboard
extends AbstractInteractiveSource {
    private static final long serialVersionUID = 8200691218381875131L;
    protected java.lang.String m_Message;
    protected AbstractClipboardData m_ClipboardData;
    protected Token m_OutputToken;

    @Override
    public java.lang.String globalInfo() {
        return "Pops up a dialog, prompting the user to accept content from clipboard.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Click 'OK' to obtain text from clipboard");
        this.m_OptionManager.add("clipboard-data", "clipboardData", new String());
    }

    @Override
    public java.lang.String getQuickInfo() {
        java.lang.String result = QuickInfoHelper.toString((OptionHandler)this, "message", this.m_Message);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "clipboardData", this.m_ClipboardData, ", data: ");
        return result;
    }

    public void setMessage(java.lang.String value) {
        this.m_Message = value;
        this.reset();
    }

    public java.lang.String getMessage() {
        return this.m_Message;
    }

    public java.lang.String messageTipText() {
        return "The message to prompt the user with.";
    }

    public void setClipboardData(AbstractClipboardData value) {
        this.m_ClipboardData = value;
        this.reset();
    }

    public AbstractClipboardData getClipboardData() {
        return this.m_ClipboardData;
    }

    public java.lang.String clipboardDataTipText() {
        return "The class for pasting a specific type of data from the clipboard.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{this.m_ClipboardData.getFlowClass()};
    }

    @Override
    public boolean doInteract() {
        if (this.isHeadless()) {
            return true;
        }
        int retVal = JOptionPane.showConfirmDialog(this.getParentComponent(), this.m_Message, this.getName(), 2);
        if (retVal == 0 && this.m_ClipboardData.canPaste()) {
            this.m_OutputToken = this.m_ClipboardData.pasteAsToken();
        }
        return retVal == 0;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

